/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.document.server.DocumentServerUtils;
import org.simantics.document.server.JSONObject;
import org.simantics.document.server.request.DocumentRequest;
import org.simantics.document.server.request.NodeRequestDynamic;
import org.simantics.utils.datastructures.Pair;

public class NodeRequest
extends VariableRead<JSONObject> {
    public static final String ERRORS = "Errors";

    public NodeRequest(Variable node) {
        super(node);
    }

    public JSONObject perform(ReadGraph graph) throws DatabaseException {
        long dura;
        long s = System.nanoTime();
        Pair attribs = (Pair)graph.syncRequest((Read)new DocumentServerUtils.AttributesRequest(this.variable));
        JSONObject staticContent = (JSONObject)((Object)attribs.first);
        if (((Collection)attribs.second).isEmpty()) {
            long dura2;
            if (DocumentRequest.PROFILE && (double)(dura2 = System.nanoTime() - s) > (double)DocumentRequest.PROFILE_THRESHOLD_NODEREQUEST * 1000.0) {
                System.err.println("NodeRequest " + System.identityHashCode((Object)this) + " in " + 1.0E-6 * (double)dura2 + "ms. " + this.variable.getURI(graph));
            }
            return staticContent;
        }
        Map dynamicContent = (Map)graph.syncRequest((Read)new NodeRequestDynamic(this.variable));
        if (dynamicContent.isEmpty()) {
            return staticContent;
        }
        JSONObject result = staticContent.clone();
        result.add(dynamicContent);
        if (dynamicContent.containsKey(ERRORS) || staticContent.getJSONField(ERRORS) != null) {
            ArrayList errorList = new ArrayList();
            if (dynamicContent.containsKey(ERRORS)) {
                errorList.addAll((List)dynamicContent.get(ERRORS));
            }
            if (staticContent.getJSONField(ERRORS) != null) {
                errorList.addAll((List)staticContent.getJSONField(ERRORS));
            }
            result.addJSONField(ERRORS, errorList);
        }
        if (DocumentRequest.PROFILE && (double)(dura = System.nanoTime() - s) > (double)DocumentRequest.PROFILE_THRESHOLD_NODEREQUEST * 1000.0) {
            System.err.println("NodeRequest " + System.identityHashCode((Object)this) + " in " + 1.0E-6 * (double)dura + "ms. " + this.variable.getURI(graph));
        }
        return result;
    }
}

