/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.util.HashSet;
import java.util.Vector;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.InternalException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.exception.TimeoutException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.request.Write;
import org.simantics.db.service.ClusterUID;
import org.simantics.db.service.InitSupport;
import org.simantics.db.service.LifecycleSupport;

public class InitSupportImpl
implements InitSupport {
    private final SessionImplSocket session;

    InitSupportImpl(SessionImplSocket session) {
        this.session = session;
    }

    public void close() throws DatabaseException, TimeoutException {
        this.session.getService(LifecycleSupport.class).close();
    }

    public void addBuiltins(final HashSet<InitSupport.Builtin> builtins) throws InternalException {
        try {
            this.session.syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    ClusterSupport cs = InitSupportImpl.this.session.getService(ClusterSupport.class);
                    Vector<InitSupport.Builtin> v = new Vector<InitSupport.Builtin>();
                    int N = builtins.size();
                    v.setSize(N + 1);
                    for (InitSupport.Builtin b : builtins) {
                        if (b.index < 1 || b.index > N) {
                            throw new RuntimeDatabaseException("Illeagal resource index for builtin. index=" + b.index + " uri=" + b.uri + " N=" + N);
                        }
                        v.set(b.index, b);
                    }
                    int i = 1;
                    while (i < N + 1) {
                        if (v.get(i) == null) {
                            throw new RuntimeDatabaseException("Missing builtin for resource index=" + i);
                        }
                        ++i;
                    }
                    ClusterBase cluster = cs.getClusterByClusterUIDOrMake(ClusterUID.Builtin);
                    long clusterId = cluster.getClusterId();
                    int i2 = 1;
                    while (i2 < N + 1) {
                        InitSupport.Builtin b = (InitSupport.Builtin)v.get(i2);
                        cs.createResource((Object)cluster, (short)b.index, clusterId);
                        ++i2;
                    }
                    cluster.setImmutable(true, cs);
                }
            });
        }
        catch (DatabaseException e) {
            throw new InternalException("Failed to init graph.", (Throwable)e);
        }
    }
}

