/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.widgets;

import java.util.concurrent.atomic.AtomicBoolean;

import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;

public class ScrolledComposite extends WidgetImpl {

    final private org.eclipse.swt.custom.ScrolledComposite composite;

    public ScrolledComposite(org.eclipse.swt.widgets.Composite parent, WidgetSupport support, int style) {
    	super(support);
        composite = new org.eclipse.swt.custom.ScrolledComposite(parent, style);
        support.register(this);
    }

    public org.eclipse.swt.custom.ScrolledComposite getWidget() {
        return composite;
    }

    @Override
    public Control getControl() {
        return composite;
    }

    private AtomicBoolean inputDisposed;

    @Override
    public void setInput(ISessionContext context, Object input) {

        if (this.inputDisposed != null)
            this.inputDisposed.set(true);
        
    }

	public void setLayout(Layout layout) {
		composite.setLayout(layout);
	}
    
}
