/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.inputs;

import org.eclipse.core.runtime.IAdaptable;

/**
 * An equals-comparable and adaptable container for a single datum. The datum
 * may be <code>null</code>. Adaptability is provided through {@link IAdaptable}
 * .
 * 
 * @author Tuukka Lehtonen
 * 
 * @param <T> the type of the datum
 */
public class Datum<T> implements IAdaptable {

    protected final T datum;

    public Datum(T datum) {
        this.datum = datum;
    }

    public T getDatum() {
        return datum;
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public Object getAdapter(Class adapter) {
        if (datum != null) {
            if (adapter.isAssignableFrom(datum.getClass()))
                return datum;
            if (datum instanceof IAdaptable)
                return ((IAdaptable) datum).getAdapter(adapter);
        }
        return null;
    }

    @Override
    public int hashCode() {
        return datum != null ? datum.hashCode() : 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Datum<?> other = (Datum<?>) obj;
        if (datum == null)
            return datum == other.datum;
        return datum.equals(other.datum);
    }

}