/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt.contentassist;

import java.util.Arrays;
import java.util.Collection;

/**
 * @author Tuukka Lehtonen
 */
public class FindExactMatch {

    public static <T extends INamedObject> T exec(String name, T... allowedValues) {
        return exec(name, Arrays.asList(allowedValues));
    }

    public static <T extends INamedObject> T exec(String name, Collection<T> allowedValues) {
        name = name.toLowerCase();
        T found = null;
        for (T obj : allowedValues) {
            if (obj.getName().toLowerCase().startsWith(name)) {
                if (found != null)
                    return null;
                found = obj;
            }
        }
        return found;
    }

}
