/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.swt.graphics.Image;
import org.simantics.browsing.ui.content.ImagerFactory;
import org.simantics.utils.datastructures.cache.IMapProvider;

/**
 * A basic {@link ImagerFactory} that uses an {@link IMapProvider} to get the
 * actual {@link Image}s based on column keys.
 * 
 * @author Tuukka Lehtonen
 */
public class ProviderImageFactory extends ConstantImagerFactory {

    public ProviderImageFactory(IMapProvider<String, Image> provider) {
        super(new ProviderImager<Image>(provider));
    }

}
