/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;

/**
 * WARNING: this adapter does not currently handle structural selections, i.e.
 * resource paths but only single resources which will result failure to show
 * correct data or even worse.
 * 
 * TODO: override {@link #canHandle(ReadGraph, Object)} and
 * {@link #openEditor(Object)} to do what's described above.
 */
public class NewPropertyViewAdapter extends AbstractResourceEditorAdapter {

    public NewPropertyViewAdapter() {
        super("New Property View", ImageDescriptor.createFromURL(
                NewPropertyViewAdapter.class.getResource("../../../../../icons/table_multiple.png")));
    }

    @Override
    public boolean canHandle(ReadGraph g, Object r) {
        return true;
    }

    @Override
    public void openEditor(Resource r) throws Exception {
        openViewWithId("org.simantics.browsing.ui.graph.propertyView", r);
    }

}
