package org.simantics.browsing.ui.swt;

import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.internal.GENodeQueryManager;
import org.simantics.browsing.ui.common.labelers.LabelerStub;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.swt.GraphExplorerImpl.GraphExplorerContext;

public class GraphExplorerToolTip extends ToolTip {

    private boolean DEBUG = false;
    
    private Tree parent;
    private NodeContext nodeContext;
    private Labeler labeler;

    private GraphExplorerContext explorerContext;
    
    public GraphExplorerToolTip(GraphExplorerContext explorerContext, Tree parent) {
        super(parent, NO_RECREATE, false);
        setHideOnMouseDown(false);
        setPopupDelay(400);
        this.explorerContext = explorerContext;
        this.parent = parent;
        this.nodeContext = null;
        if (DEBUG)
            System.out.println("GraphExplorerToolTip constructor called for parent : " + parent + ", class : " + parent.getClass().toString());
    }

    @Override
    protected Composite createToolTipContentArea(Event event, Composite parent) {
        return ((LabelerStub) labeler).createToolTipContentArea(event, parent, nodeContext);
    }
    
    @Override
    protected boolean shouldCreateToolTip(Event event) {
        TreeItem treeItem = parent.getItem(new Point(event.x, event.y));
        if (treeItem == null)
            return false;
        GENodeQueryManager manager = new GENodeQueryManager(explorerContext, null, null, TreeItemReference.create(treeItem.getParentItem()));
        nodeContext = (NodeContext) treeItem.getData();
        if (nodeContext != null)
            labeler = manager.query(nodeContext, BuiltinKeys.SELECTED_LABELER);
        if (nodeContext == null || !(labeler instanceof LabelerStub))
            return false;
        return ((LabelerStub) labeler).shouldCreateToolTip(event, nodeContext);
    }

    public void setGraphExplorerContext(GraphExplorerContext explorerContext) {
        this.explorerContext = explorerContext;
    }

}
