/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.common.node.IDoubleClickableNode;
import org.simantics.utils.ui.AdaptionUtils;

/**
 * A double click event handler for {@link GraphExplorer} that tries to see whether
 * 
 * @author Tuukka Lehtonen
 */
public class DoubleClickableNodeMouseListener extends GraphExplorerMouseAdapter {

    public DoubleClickableNodeMouseListener(GraphExplorer ge) {
        super(ge);
    }

    @Override
    protected void handleContextDoubleClick(Control tree, ISelection context) {
        IDoubleClickableNode doubleClickable = AdaptionUtils.adaptToSingle(context, IDoubleClickableNode.class);
        if (doubleClickable != null) {
            doubleClickable.handleDoubleClick();
        }
    }

}
