/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.core.runtime.IAdaptable;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.SelectionDataResolver;
import org.simantics.ui.selection.ExplorerInputContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.ui.utils.ResourceAdaptionUtils;

/**
 * @author Tuukka Lehtonen
 */
public class DefaultSelectionDataResolver implements SelectionDataResolver {

    @Override
    public Object resolve(Object o) {
		
        if(o instanceof NodeContext)
            return (NodeContext)o;
        if(o instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)o;
            NodeContext nodeContext = (NodeContext)adaptable.getAdapter(NodeContext.class);
            if(nodeContext != null)
                return nodeContext;
            WorkbenchSelectionElement wse = (WorkbenchSelectionElement)adaptable.getAdapter(WorkbenchSelectionElement.class);
            if(wse != null)
                return wse.getContent(ExplorerInputContentType.INSTANCE);
        }
        if(o instanceof WorkbenchSelectionElement) {
    		WorkbenchSelectionElement wse = (WorkbenchSelectionElement)o;
    		if(wse != null) return wse.getContent(ExplorerInputContentType.INSTANCE);
        }
        return ResourceAdaptionUtils.adaptToResource(o);
        
	}

}
