/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchActionConstants;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.IPageSite;

/**
 * @author Tuukka Lehtonen
 */
public class ContextMenuInitializer implements IContextMenuInitializer {

    private final String text;
    private final String id;

    public ContextMenuInitializer(String id) {
        this("", id);
    }

    public ContextMenuInitializer(String text, String id) {
        this.text = text;
        this.id = id;
    }

    @Override
    public IMenuManager createContextMenu(Control control, ISelectionProvider selectionProvider, IWorkbenchSite site) {
        final MenuManager mm = new MenuManager(text, id);

        mm.setRemoveAllWhenShown(true);
        mm.addMenuListener(new IMenuListener() {
            @Override
            public void menuAboutToShow(IMenuManager manager) {
                initializeOpenedMenu(manager);
            }
        });

        Menu menu = mm.createContextMenu(control);
        control.setMenu(menu);

        if (site != null) {
            if (site instanceof IWorkbenchPartSite) {
                ((IWorkbenchPartSite) site).registerContextMenu(mm.getId(), mm, selectionProvider);
            } else if (site instanceof IPageSite) {
                ((IPageSite) site).registerContextMenu(mm.getId(), mm, selectionProvider);
            }
        }

        return mm;
    }

    protected void initializeOpenedMenu(IMenuManager mm) {
        mm.add(new GroupMarker(IWorkbenchActionConstants.WB_START));
//        mm.add(new GroupMarker(IWorkbenchActionConstants.NEW_EXT));
//        mm.add(new GroupMarker(IWorkbenchActionConstants.OPEN_EXT));
//        mm.add(new GroupMarker(IWorkbenchActionConstants.IMPORT_EXT));
//        mm.add(new Separator(IWorkbenchActionConstants.MB_ADDITIONS));
//        mm.add(new GroupMarker(IWorkbenchActionConstants.WB_END));
        //mm.add(new Separator());
    }

}