/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.swt;

import java.util.Collection;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.processors.UserSelectedComparableFactoryQueryProcessor;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.ui.ISelectionUtils;
import org.simantics.utils.ui.LayoutUtils;

/**
 * TODO: support multiselection within the IGraphExplorer
 */
public class ComparatorSelector extends Composite {

    Font smallFont;

    public ComparatorSelector(final GraphExplorer explorer, final UserSelectedComparableFactoryQueryProcessor queryProcessor, Composite parent, int style) {

        super(parent, style);

        setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());

        setLayout(LayoutUtils.createNoBorderGridLayout(1, false));

        final Combo combo = new Combo(this, SWT.READ_ONLY);

        Font initialFont = combo.getFont();
        FontData[] fontData = initialFont.getFontData();
        for (int i = 0; i < fontData.length; i++) {
            fontData[i].setHeight(fontData[i].getHeight() - 1);
        }
        smallFont = new Font(getDisplay(), fontData);
        combo.setFont(smallFont);

        combo.setLayoutData(GridDataFactory.fillDefaults().grab(true, false).create());
        combo.add("-- No comparators --");
        combo.select(0);

        combo.addSelectionListener(new SelectionListener() {

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                widgetSelected(e);
            }

            @SuppressWarnings("unchecked")
            @Override
            public void widgetSelected(SelectionEvent e) {

                int index = combo.getSelectionIndex();

                Pair<ComparableContextFactory, NodeContext> pair =
                    (Pair<ComparableContextFactory, NodeContext>)combo.getData(String.valueOf(index));
                if (pair == null)
                    return;

                queryProcessor.select(pair.second, pair.first);

            }

        });

        IPostSelectionProvider selectionProvider = (IPostSelectionProvider)explorer.getAdapter(IPostSelectionProvider.class);

        selectionProvider.addSelectionChangedListener(new ISelectionChangedListener() {

            @Override
            public void selectionChanged(SelectionChangedEvent event) {

                ISelection selection = event.getSelection();
                
                NodeContext context = ISelectionUtils.getSinglePossibleKey(selection, SelectionHints.KEY_MAIN, NodeContext.class);

                if(context == null) {
                    context = explorer.getRoot();
                }

                assert(context != null);

                Collection<ComparableContextFactory> factories = explorer.query(context, BuiltinKeys.COMPARABLE_FACTORIES);
                if(factories == null) {
                    combo.removeAll();
                    combo.add("-- No comparators --");
                    combo.select(0);
                    return;
                }

                ComparableContextFactory oldSelection = queryProcessor.getComparator(context);

                combo.removeAll();
                if(factories != null) {
                    for(ComparableContextFactory f : factories) {
                        int index = combo.getItemCount();
                        combo.add(f.toString());
                        combo.setData(String.valueOf(index), new Pair<ComparableContextFactory, NodeContext>(f, context));
                        if(f == oldSelection) {
                            combo.select(index);
                        }
                    }
                }
                if(combo.getItemCount() == 0) {
                    combo.add("-- No comparators --");
                }
                if(combo.getSelectionIndex() == -1) {
                    combo.select(0);
                }

            }

        });

    }

    @Override
    public void dispose() {
        if (isDisposed())
            return;
        smallFont.dispose();
        super.dispose();
    }

}
