/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils;

import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.spreadsheet.resource.SpreadsheetResource;

public class SheetUtils {
    public static Resource createSheet(WriteGraph graph, Resource book, String name, String[] colNames, int[] colWidths) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
        Resource result = graph.newResource();
        graph.claim(result, L0.InstanceOf, null, sr.Spreadsheet);
        if (name == null) {
            name = NameUtils.findFreshEscapedName((ReadGraph)graph, (String)"Sheet", (Resource)book, (Resource)L0.ConsistsOf);
        }
        graph.claimLiteral(result, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        graph.claim(book, L0.ConsistsOf, L0.PartOf, result);
        Resource newCell = graph.newResource();
        graph.claim(newCell, L0.InstanceOf, null, sr.Dimensions);
        graph.claimLiteral(newCell, L0.HasName, L0.NameOf, L0.String, (Object)"Dimensions", (Binding)Bindings.STRING);
        graph.addLiteral(newCell, sr.Dimensions_fitColumns, sr.Dimensions_fitColumns_Inverse, L0.Boolean, (Object)false, (Binding)Bindings.BOOLEAN);
        graph.addLiteral(newCell, sr.Dimensions_fitRows, sr.Dimensions_fitRows_Inverse, L0.Boolean, (Object)false, (Binding)Bindings.BOOLEAN);
        graph.addLiteral(newCell, sr.Dimensions_columnCount, sr.Dimensions_columnCount_Inverse, L0.Integer, (Object)128, (Binding)Bindings.INTEGER);
        graph.addLiteral(newCell, sr.Dimensions_rowCount, sr.Dimensions_rowCount_Inverse, L0.Integer, (Object)256, (Binding)Bindings.INTEGER);
        graph.claim(result, L0.ConsistsOf, L0.PartOf, newCell);
        newCell = graph.newResource();
        graph.claim(newCell, L0.InstanceOf, null, sr.Headers);
        graph.claimLiteral(newCell, L0.HasName, L0.NameOf, L0.String, (Object)"Headers", (Binding)Bindings.STRING);
        graph.addLiteral(newCell, sr.Headers_columnLabels, sr.Headers_columnLabels_Inverse, L0.StringArray, (Object)colNames, (Binding)Bindings.STRING_ARRAY);
        graph.addLiteral(newCell, sr.Headers_columnWidths, sr.Headers_columnWidths_Inverse, L0.IntegerArray, (Object)colWidths, (Binding)Bindings.INT_ARRAY);
        graph.claim(result, L0.ConsistsOf, L0.PartOf, newCell);
        return result;
    }

    public static String getStringRepresentation(ReadGraph graph, Resource model, String sheetName, String range) throws DatabaseException {
        Resource configuration = graph.getPossibleObject(model, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
        Variable sheetVariable = null;
        for (Resource book : (Collection)graph.syncRequest((Read)new ObjectsWithType(configuration, L0.ConsistsOf, SHEET.Book))) {
            for (Resource sheet : (Collection)graph.syncRequest((Read)new ObjectsWithType(book, L0.ConsistsOf, SHEET.Spreadsheet))) {
                if (!sheetName.equals(NameUtils.getSafeName((ReadGraph)graph, (Resource)sheet))) continue;
                sheetVariable = Variables.getVariable((ReadGraph)graph, (Resource)sheet);
            }
        }
        if (sheetVariable == null) {
            return null;
        }
        Variable rangeVariable = sheetVariable.getChild(graph, range);
        String[][] rangeCells = (String[][])rangeVariable.getPropertyValue(graph, "rangeCellNames");
        if (rangeCells == null || rangeCells[0].length <= 1) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        while (i < rangeCells.length) {
            sb.append("{");
            int j = 0;
            while (j < rangeCells[i].length) {
                String valueCell = rangeCells[i][j];
                Variable cell = sheetVariable.getChild(graph, valueCell);
                Variant valueVariant = (Variant)cell.getPropertyValue(graph, "content", (Binding)Bindings.VARIANT);
                Object valueObject = valueVariant.getValue();
                sb.append(valueObject.toString());
                if (j < rangeCells[i].length - 1) {
                    sb.append(", ");
                }
                ++j;
            }
            sb.append("}");
            if (i < rangeCells.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        sb.append("}");
        return sb.toString();
    }
}

