/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.utils;

import java.util.Map;
import java.util.UUID;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Template;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.document.DocumentResource;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils;
import org.simantics.operation.Layer0X;
import org.simantics.project.ontology.ProjectResource;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.utils.ProfileEntries;
import org.simantics.sysdyn.utils.SheetUtils;
import org.simantics.utils.datastructures.ArrayMap;

public class ModelUtils {
    public static SysdynModel getModel(ReadGraph graph, Resource variable) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource configuration = graph.getPossibleObject(variable, l0.PartOf);
        if (configuration == null) {
            return null;
        }
        SysdynModelManager sdm = SysdynModelManager.getInstance(Simantics.getSession());
        SysdynModel model = sdm.getModel(graph, configuration);
        try {
            model.update(graph);
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        return model;
    }

    public static Resource createModel(WriteGraph graph) {
        return ModelUtils.createModelAt(graph, (Resource)Simantics.getProject().get());
    }

    public static Resource createModelAt(WriteGraph g, Resource library) {
        g.markUndoPoint();
        try {
            Layer0 l0 = Layer0.getInstance((ReadGraph)g);
            Layer0X L0X = Layer0X.getInstance((ReadGraph)g);
            SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
            SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)g);
            ModelingUtils mu = new ModelingUtils(g);
            DocumentResource DOC = DocumentResource.getInstance((ReadGraph)g);
            String modelName = NameUtils.findFreshName((ReadGraph)g, (String)"Model", (Resource)library, (Resource)l0.ConsistsOf, (String)"%s%d");
            Resource project = (Resource)Simantics.getProject().get();
            Resource model = GraphUtils.create2((WriteGraph)g, (Resource)sr.SysdynModel, (Object[])new Object[]{l0.PartOf, project, l0.HasName, modelName, l0.HasLabel, modelName, L0X.IsActivatedBy, project});
            GraphUtils.create2((WriteGraph)g, (Resource)sr.Validations_Dependencies_MissingDependencyConnectionsIssueSource, (Object[])new Object[]{L0X.IsActivatedBy, model, l0.PartOf, model});
            GraphUtils.create2((WriteGraph)g, (Resource)sr.Validations_Dependencies_DependencyConnectionsIssueSource, (Object[])new Object[]{L0X.IsActivatedBy, model, l0.PartOf, model});
            GraphUtils.create2((WriteGraph)g, (Resource)sr.Validations_Expressions_ExpressionIssueSource, (Object[])new Object[]{L0X.IsActivatedBy, model, l0.PartOf, model});
            GraphUtils.create2((WriteGraph)g, (Resource)sr.Validations_Enumerations_EnumerationIssueSource, (Object[])new Object[]{L0X.IsActivatedBy, model, l0.PartOf, model});
            GraphUtils.create2((WriteGraph)g, (Resource)sr.Validations_Units_UnitIssueSource, (Object[])new Object[]{L0X.IsActivatedBy, model, l0.PartOf, model, IssueResource.getInstance((ReadGraph)g).IssueSource_active, false});
            Resource conf = GraphUtils.create2((WriteGraph)g, (Resource)sr.Configuration, (Object[])new Object[]{l0.PartOf, model, L0X.IsBaseRealizationOf, model, l0.HasName, modelName});
            Resource diagram = g.newResource();
            ((Template)g.adapt(sr.ConfigurationDiagramTemplate, Template.class)).apply(g, (Map)ArrayMap.keys((Object[])new String[]{"", "diagram", "name"}).values(new Object[]{conf, diagram, "Diagrammi"}));
            g.claim(model, mu.SIMU.HasConfiguration, conf);
            Resource book = g.newResource();
            g.claim(book, l0.InstanceOf, null, SHEET.Book);
            g.addLiteral(book, l0.HasName, l0.NameOf, l0.String, (Object)("Book" + UUID.randomUUID().toString()), (Binding)Bindings.STRING);
            g.claim(conf, l0.ConsistsOf, l0.PartOf, book);
            SheetUtils.createSheet(g, book, "Sheet1", new String[0], new int[]{50});
            ModelingResources mr = ModelingResources.getInstance((ReadGraph)g);
            for (Resource trigger : g.getObjects(diagram, L0X.HasTrigger)) {
                if (!g.isInstanceOf(trigger, mr.DiagramToCompositeMapping)) continue;
                g.deny(diagram, L0X.HasTrigger, trigger);
            }
            Resource mapping = g.newResource();
            g.claim(mapping, l0.InstanceOf, null, sr.DiagramToCompositeMapping);
            g.claim(diagram, L0X.HasTrigger, mapping);
            Resource report = GraphUtils.create2((WriteGraph)g, (Resource)DOC.Report, (Object[])new Object[]{DOC.HasDocumentation, "===Report==="});
            GraphUtils.create2((WriteGraph)g, (Resource)sr.BasicExperiment, (Object[])new Object[]{l0.HasName, "Experiment", l0.HasLabel, "Experiment", DOC.HasReportFactory, report, l0.PartOf, model});
            ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)g);
            for (Resource dep : g.getObjects(library, l0.IsLinkedTo)) {
                if (!g.isInstanceOf(dep, PROJ.NamespaceRequirement)) continue;
                for (Resource req : g.getObjects(dep, PROJ.RequiresNamespace)) {
                    Resource target;
                    String uri = (String)g.getPossibleValue(req, (Binding)Bindings.STRING);
                    if (uri == null || (target = g.getResource(uri)) == null) continue;
                    g.claim(model, l0.IsLinkedTo, null, target);
                }
            }
            ModelUtils.createSCLMain(g, model);
            ProfileEntries.createStandardProfiles(g, model);
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)g, (String)("Created new Sysdyn Model '" + modelName + "' " + model.toString()));
            return model;
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return null;
        }
    }

    public static void createSCLMain(WriteGraph graph, Resource model) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource SCLModule = GraphUtils.create2((WriteGraph)graph, (Resource)L0.SCLModule, (Object[])new Object[]{L0.PartOf, model, L0.HasName, "SCLMain"});
        if (graph.hasStatement(SCLModule, L0.SCLModule_definition)) {
            graph.deny(SCLModule, L0.SCLModule_definition);
        }
        graph.claimLiteral(SCLModule, L0.SCLModule_definition, (Object)"include \"Simantics/All\"\ninclude \"Simantics/Sysdyn\"\n", (Binding)Bindings.STRING);
    }
}

