/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.unitParser.nodes;

import java.util.ArrayList;
import java.util.HashMap;
import org.simantics.sysdyn.unitParser.UnitCheckingException;
import org.simantics.sysdyn.unitParser.UnitCheckingNode;
import org.simantics.sysdyn.unitParser.nodes.FunctionArguments;
import org.simantics.sysdyn.unitParser.nodes.NamedArguments;
import org.simantics.sysdyn.unitParser.nodes.UnitResult;
import org.simantics.sysdyn.utils.Function;
import org.simantics.utils.datastructures.Pair;

public class FunctionCall
extends UnitCheckingNode {
    public FunctionCall(int id) {
        super(id);
    }

    @Override
    public UnitResult getUnits(HashMap<String, String> units, ArrayList<Function> functions, boolean allowEquivalents) throws UnitCheckingException {
        UnitCheckingNode functionLabelNode = (UnitCheckingNode)this.jjtGetChild(0);
        String functionLabel = functionLabelNode.printNode();
        UnitCheckingNode functionArgumentsWithParenthesisNode = (UnitCheckingNode)this.jjtGetChild(1);
        UnitCheckingNode functionArgumentsNode = (UnitCheckingNode)functionArgumentsWithParenthesisNode.jjtGetChild(1);
        UnitCheckingException u = null;
        for (Function f : functions) {
            if (!f.getName().equals(functionLabel)) continue;
            ArrayList<Function.Input> inputs = f.getInputList();
            ArrayList<Pair<UnitResult, String>> argumentUnits = FunctionCall.getArgumentsOf(functionArgumentsNode, units, functions, allowEquivalents);
            HashMap<String, String> correspondences = FunctionCall.getReplacementUnitCorrespondences(inputs, argumentUnits);
            try {
                if (f.areArgumentUnitsValid(argumentUnits, correspondences, functions, allowEquivalents, units)) {
                    Function.Output o = f.getOutputList().get(0);
                    return o.getUnitResult(units, f, functions, allowEquivalents, correspondences);
                }
                if (u != null) continue;
                u = FunctionCall.getException(functionLabelNode, inputs, argumentUnits);
            }
            catch (UnitCheckingException e) {
                u = e;
            }
        }
        if (u == null) {
            UnitResult result = new UnitResult(allowEquivalents);
            result.setUnitType(UnitResult.UnitType.ANY);
            return result;
        }
        throw u;
    }

    private static HashMap<String, String> getReplacementUnitCorrespondences(ArrayList<Function.Input> inputs, ArrayList<Pair<UnitResult, String>> argumentUnits) {
        HashMap<String, String> correspondences = new HashMap<String, String>();
        int i = 0;
        while (i < argumentUnits.size()) {
            if (argumentUnits.get((int)i).second != null) {
                for (Function.Input input : inputs) {
                    if (!input.name.equals(argumentUnits.get((int)i).second)) continue;
                    FunctionCall.addPossibleCorrespondence(correspondences, input, (UnitResult)argumentUnits.get((int)i).first);
                }
            } else if (inputs.size() > i) {
                FunctionCall.addPossibleCorrespondence(correspondences, inputs.get(i), (UnitResult)argumentUnits.get((int)i).first);
            }
            ++i;
        }
        return correspondences;
    }

    private static void addPossibleCorrespondence(HashMap<String, String> correspondences, Function.Input input, UnitResult argumentUnit) {
        if (correspondences.containsKey(input.unit) && argumentUnit.getUnitType() == UnitResult.UnitType.SCALAR) {
            return;
        }
        if (input.unit.matches("'[a-zA-Z]")) {
            String fullUnit = argumentUnit.getCleanFullUnit();
            if ("".equals(fullUnit)) {
                fullUnit = "1";
            }
            correspondences.put(input.unit, fullUnit);
        }
    }

    private static UnitCheckingException getException(UnitCheckingNode functionLabelNode, ArrayList<Function.Input> inputs, ArrayList<Pair<UnitResult, String>> argumentUnits) {
        String exception = new String("Function arguments do not have correct units. Expected " + functionLabelNode.printNode() + "(");
        int i = 0;
        while (i < inputs.size()) {
            Function.Input input = inputs.get(i);
            if (i == 0) {
                exception = String.valueOf(exception) + " ";
            }
            exception = String.valueOf(exception) + "[" + input.unit + "]";
            if (input.variableLength) {
                exception = String.valueOf(exception) + "... ";
            }
            if (i != inputs.size() - 1) {
                exception = String.valueOf(exception) + ", ";
            }
            ++i;
        }
        exception = String.valueOf(exception) + " ), got " + functionLabelNode.printNode() + "(";
        i = 0;
        while (i < argumentUnits.size()) {
            UnitResult argumentUnit = (UnitResult)argumentUnits.get((int)i).first;
            if (i == 0) {
                exception = String.valueOf(exception) + " ";
            }
            exception = String.valueOf(exception) + "[" + argumentUnit.getCleanFullUnit() + "]";
            if (i != argumentUnits.size() - 1) {
                exception = String.valueOf(exception) + ", ";
            }
            ++i;
        }
        exception = String.valueOf(exception) + " ).";
        return new UnitCheckingException(exception);
    }

    private static ArrayList<Pair<UnitResult, String>> getArgumentsOf(UnitCheckingNode functionArgumentsNode, HashMap<String, String> units, ArrayList<Function> functions, boolean allowEquivalents) throws UnitCheckingException {
        ArrayList<Pair<UnitResult, String>> argumentUnits = new ArrayList<Pair<UnitResult, String>>();
        if (functionArgumentsNode instanceof FunctionArguments) {
            UnitCheckingNode firstArg = (UnitCheckingNode)functionArgumentsNode.jjtGetChild(0);
            if (firstArg instanceof NamedArguments) {
                argumentUnits.addAll(FunctionCall.getNamedArgumentsOf(firstArg, units, functions, allowEquivalents));
            } else {
                argumentUnits.add((Pair<UnitResult, String>)new Pair((Object)firstArg.getUnits(units, functions, allowEquivalents), null));
                if (functionArgumentsNode.jjtGetNumChildren() > 1) {
                    UnitCheckingNode next = (UnitCheckingNode)functionArgumentsNode.jjtGetChild(1);
                    argumentUnits.addAll(FunctionCall.getArgumentsOf(next, units, functions, allowEquivalents));
                }
            }
        }
        return argumentUnits;
    }

    private static ArrayList<Pair<UnitResult, String>> getNamedArgumentsOf(UnitCheckingNode namedArgumentsNode, HashMap<String, String> units, ArrayList<Function> functions, boolean allowEquivalents) throws UnitCheckingException {
        ArrayList<Pair<UnitResult, String>> argumentUnits = new ArrayList<Pair<UnitResult, String>>();
        if (namedArgumentsNode instanceof NamedArguments) {
            UnitCheckingNode firstArg = (UnitCheckingNode)namedArgumentsNode.jjtGetChild(0);
            String argumentName = firstArg.jjtGetFirstToken().image;
            argumentUnits.add((Pair<UnitResult, String>)new Pair((Object)firstArg.getUnits(units, functions, allowEquivalents), (Object)argumentName));
            if (namedArgumentsNode.jjtGetNumChildren() > 1) {
                UnitCheckingNode next = (UnitCheckingNode)namedArgumentsNode.jjtGetChild(1);
                argumentUnits.addAll(FunctionCall.getNamedArgumentsOf(next, units, functions, allowEquivalents));
            }
        }
        return argumentUnits;
    }
}

