/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.unitParser.nodes;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.simantics.sysdyn.unitParser.ParseException;
import org.simantics.sysdyn.unitParser.UnitCheckingException;
import org.simantics.sysdyn.unitParser.UnitCheckingNode;
import org.simantics.sysdyn.unitParser.UnitParser;
import org.simantics.sysdyn.unitParser.nodes.UnitResult;
import org.simantics.sysdyn.utils.Function;

public class ComponentReferenceFull
extends UnitCheckingNode {
    public ComponentReferenceFull(int id) {
        super(id);
    }

    protected UnitResult parseUnits(String units, ArrayList<Function> functions, boolean allowEquivalents) throws UnitCheckingException {
        StringReader sr = new StringReader(units);
        UnitParser parser = new UnitParser(sr);
        try {
            UnitCheckingNode node = (UnitCheckingNode)parser.expr();
            return node.getUnits(null, functions, allowEquivalents);
        }
        catch (UnitCheckingException e) {
            e.printStackTrace();
        }
        catch (ParseException parseException) {
            throw new UnitCheckingException("Cannot validate units: Syntax error in expression.");
        }
        return null;
    }

    @Override
    public UnitResult getUnits(HashMap<String, String> units, ArrayList<Function> functions, boolean allowEquivalents) throws UnitCheckingException {
        String node = this.printNode();
        if ("dmnl".equals(node)) {
            UnitResult result = new UnitResult(allowEquivalents);
            result.setUnitType(UnitResult.UnitType.DMNL);
            return result;
        }
        if (units != null) {
            if (!units.containsKey(node) || units.get(node) == null) {
                throw new UnitCheckingException("No units defined for " + node);
            }
            return this.parseUnits(units.get(node), functions, allowEquivalents);
        }
        UnitResult result = new UnitResult(allowEquivalents);
        result.addDivident(node);
        result.append(node);
        return result;
    }

    @Override
    public String printNode() {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.jjtGetNumChildren()) {
            UnitCheckingNode node = (UnitCheckingNode)this.jjtGetChild(i);
            sb.append(node.printNode());
            ++i;
        }
        return sb.toString();
    }
}

