/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.solver;

import java.util.HashMap;
import java.util.Map;
import org.simantics.db.Resource;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.manager.SysdynExperimentFactory;
import org.simantics.sysdyn.solver.SolverSettings;

public class Solvers {
    private Map<SolverSettings.SolverType, SysdynExperimentFactory> gameExperimentFactories = new HashMap<SolverSettings.SolverType, SysdynExperimentFactory>();
    private static Solvers INSTANCE;

    private Solvers() {
    }

    public static synchronized Solvers getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Solvers();
        }
        return INSTANCE;
    }

    public static synchronized SysdynExperiment instantiateGameExperiment(SolverSettings.SolverType solver, Resource experiment, Resource model) throws Exception {
        Solvers s = Solvers.getInstance();
        SysdynExperimentFactory factory = s.gameExperimentFactories.get((Object)solver);
        if (factory == null) {
            throw new Exception("No game experiment factory registered as " + (Object)((Object)solver));
        }
        return factory.create(experiment, model);
    }

    public static synchronized void registerGameExperimentFactory(SolverSettings.SolverType solver, SysdynExperimentFactory factory) {
        Solvers s = Solvers.getInstance();
        s.gameExperimentFactories.put(solver, factory);
    }

    public static synchronized void unregisterGameExperimentFactory(SolverSettings.SolverType solver) {
        Solvers s = Solvers.getInstance();
        s.gameExperimentFactories.remove((Object)solver);
    }
}

