/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation.expressions;

import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.jfreechart.chart.ChartUtils;
import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.RelatedValue;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.Model;
import org.simantics.sysdyn.representation.Sheet;
import org.simantics.sysdyn.representation.expressions.Expression;
import org.simantics.sysdyn.representation.utils.FormatUtils;
import org.simantics.sysdyn.representation.utils.IndexUtils;
import org.simantics.sysdyn.representation.utils.SheetFormatUtils;
import org.simantics.sysdyn.representation.utils.UnitUtils;

@GraphType(value="http://www.simantics.org/Sysdyn-1.1/WithLookupExpression")
public class WithLookupExpression
extends Expression {
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/WithLookupExpression/lookup")
    private String lookupTable;
    @RelatedValue(value="http://www.simantics.org/Sysdyn-1.1/WithLookupExpression/expression")
    private String equation;

    @Override
    public String getEquation() {
        String equation = FormatUtils.replaceWhitespace(this.equation);
        equation = FormatUtils.formatExpressionForModelica(this.parent, equation);
        String range = IndexUtils.rangeToIndexes(this.parent, this.getArrayRange());
        return "    " + this.parent.getModelicaName() + (range.equals("[:]") ? "" : range) + " = interpolate(" + equation + ", " + SheetFormatUtils.reformatSheetReferences(this.parent, this.lookupTable) + ");\n";
    }

    @Override
    public String getModelicaExpression() {
        return "interpolate(" + FormatUtils.replaceWhitespace(this.equation) + ", " + this.lookupTable + ")";
    }

    @Override
    public String getExpression() {
        return "interpolate(" + this.equation + ", " + this.lookupTable + ")";
    }

    @Override
    public String validateUnits(ReadGraph graph, SysdynModel model) {
        if (this.parent.getUnit() == null) {
            return "Unit not defined for " + this.parent.getName();
        }
        String result = UnitUtils.expressionUnitsValid(graph, model, this.parent.getParentConfiguration(), this.equation);
        if (result == null) {
            result = UnitUtils.matchUnits(graph, model, this.parent.getParentConfiguration(), this.parent.getUnit(), this.lookupTable);
        }
        return result;
    }

    @Override
    public String getDocumentationExpression(ReadGraph graph) throws DatabaseException {
        String expression = super.getDocumentationExpression(graph);
        String table = this.lookupTable;
        Sheet sheet = null;
        if (table.matches("[a-zA-Z0-9]*\\([a-zA-Z0-9:]*\\)")) {
            Object parent;
            String name = table.substring(0, table.indexOf("("));
            String range = table.substring(table.indexOf("(") + 1, table.indexOf(")"));
            IndependentVariable independentVariable = this.getParent();
            Configuration conf = independentVariable.getParentConfiguration();
            Model model = conf.getModel();
            if (model == null && (parent = conf.getModuleType().getParent()) instanceof Model) {
                model = (Model)parent;
            }
            if (model != null) {
                for (IElement e : model.getModelConfiguration().getElements()) {
                    if (!(e instanceof Sheet) || !name.equals(((Sheet)e).getName())) continue;
                    sheet = (Sheet)e;
                    Variable v = Variables.getVariable((ReadGraph)graph, (Resource)sheet.getResource());
                    Variable rangeVariable = v.getChild(graph, range);
                    Range r = SpreadsheetUtils.decodeRange((String)range);
                    if (r.endColumn - r.startColumn != 1) break;
                    String[][] rangeCells = (String[][])rangeVariable.getPropertyValue(graph, "rangeCellNames");
                    StringBuilder sb = new StringBuilder();
                    boolean firstRow = true;
                    int i = 0;
                    while (i < rangeCells.length) {
                        if (!firstRow) {
                            sb.append(",");
                        }
                        firstRow = false;
                        boolean firstColumn = true;
                        int j = 0;
                        while (j < rangeCells[i].length) {
                            if (!firstColumn) {
                                sb.append(",");
                            }
                            firstColumn = false;
                            sb.append(sheet.getCells().get((Object)rangeCells[i][j]));
                            ++j;
                        }
                        ++i;
                    }
                    table = sb.toString();
                    break;
                }
            }
        }
        table = table.replace("{", "");
        table = table.replace("}", "");
        String[] split = table.split(",");
        double[] x = new double[split.length / 2];
        double[] y = new double[split.length / 2];
        try {
            int i = 0;
            while (i < split.length / 2) {
                x[i] = Double.parseDouble(split[i * 2]);
                y[i] = Double.parseDouble(split[i * 2 + 1]);
                ++i;
            }
            DefaultXYDataset dataset = new DefaultXYDataset();
            dataset.addSeries((Comparable)((Object)"lookup"), (double[][])new double[][]{y, x});
            JFreeChart chart = ChartFactory.createXYLineChart((String)"", (String)"", (String)"", (XYDataset)dataset, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)false, (boolean)false, (boolean)false);
            StringWriter writer = new StringWriter();
            ChartUtils.writeSVG((JFreeChart)chart, (Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), (Writer)writer);
            writer.flush();
            String svg = writer.toString();
            writer.close();
            svg = svg.substring(svg.indexOf("<svg"));
            svg = svg.replaceAll("[\r\n]+", "");
            expression = String.valueOf(expression) + "<div>" + svg + "</div>";
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (IOException iOException) {}
        return expression;
    }

    public String getLookupEquation() {
        return this.equation;
    }

    public double[] getPoints() {
        String[] table = this.lookupTable.replaceAll("\\{|\\}", "").split(",");
        double[] points = new double[table.length];
        int i = 0;
        while (i < table.length) {
            try {
                points[i] = Double.parseDouble(table[i]);
            }
            catch (NumberFormatException numberFormatException) {}
            ++i;
        }
        return points;
    }

    public double[] getXPoints() {
        double[] points = this.getPoints();
        double[] xPoints = new double[points.length / 2];
        int i = 0;
        while (i < points.length) {
            xPoints[i] = points[2 * i];
            ++i;
        }
        return xPoints;
    }

    public double[] getYPoints() {
        double[] points = this.getPoints();
        double[] yPoints = new double[points.length / 2];
        int i = 0;
        while (i < points.length) {
            yPoints[i] = points[2 * i + 1];
            ++i;
        }
        return yPoints;
    }
}

