/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.representation;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.simantics.sysdyn.expressionParser.ExpressionParser;
import org.simantics.sysdyn.expressionParser.ParseException;
import org.simantics.sysdyn.expressionParser.Token;
import org.simantics.sysdyn.representation.Book;
import org.simantics.sysdyn.representation.Configuration;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.EnumerationIndex;
import org.simantics.sysdyn.representation.Function;
import org.simantics.sysdyn.representation.IElement;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.Input;
import org.simantics.sysdyn.representation.Model;
import org.simantics.sysdyn.representation.Module;
import org.simantics.sysdyn.representation.ModuleType;
import org.simantics.sysdyn.representation.Sheet;
import org.simantics.sysdyn.representation.Stock;
import org.simantics.sysdyn.representation.expressions.IExpression;
import org.simantics.sysdyn.representation.utils.FormatUtils;
import org.simantics.sysdyn.representation.utils.RepresentationUtils;

public enum Variability {
    PARAMETER("parameter"),
    CONSTANT("constant"),
    CONTINUOUS("");

    private static List<String> timeDependentFunctions;
    private String text;

    static {
        timeDependentFunctions = Arrays.asList("pre", "delay");
    }

    private Variability(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public static Variability fromString(String text) {
        if (text != null) {
            Variability[] variabilityArray = Variability.values();
            int n = variabilityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Variability v = variabilityArray[n2];
                if (text.equalsIgnoreCase(v.text)) {
                    return v;
                }
                ++n2;
            }
        }
        return null;
    }

    private static boolean isParameter(IndependentVariable variable, Configuration configuration, String reference, boolean allowVariables) {
        Object parent;
        String r = reference.split("\\.")[0];
        for (IElement element : configuration.getElements()) {
            Input i;
            if (element instanceof Module) {
                Module m = (Module)element;
                if (!r.equals(m.getName())) continue;
                if (!reference.contains(".")) {
                    return true;
                }
                Configuration moduleConfiguration = m.getType().getConfiguration();
                return Variability.isParameter(variable, moduleConfiguration, reference.substring(reference.indexOf(".") + 1), allowVariables);
            }
            if (element instanceof Book) {
                for (Sheet sheet : ((Book)element).getSheets()) {
                    if (!r.equals(sheet.getName())) continue;
                    return true;
                }
                continue;
            }
            if (element instanceof Enumeration) {
                Enumeration e = (Enumeration)element;
                if (!r.equals(e.getName())) continue;
                String[] split = reference.split("\\.");
                if (split.length == 1) {
                    return true;
                }
                if (split.length != 2) continue;
                if (split[1].equals("size") || split[1].equals("elements")) {
                    return true;
                }
                for (EnumerationIndex ei : e.getEnumerationIndexes()) {
                    if (!split[1].equals(ei.getName())) continue;
                    return true;
                }
                continue;
            }
            if (!allowVariables) continue;
            if (element instanceof IndependentVariable && !(element instanceof Stock)) {
                IndependentVariable v = (IndependentVariable)element;
                if (!r.equals(v.getName())) continue;
                if (v.getName().equals(variable.getName())) {
                    return false;
                }
                return Variability.getVariability(v) != CONTINUOUS;
            }
            if (!(element instanceof Input) || !r.equals((i = (Input)element).getName())) continue;
            return i.getVariability() != null && !i.getVariability().equals(CONTINUOUS.getText());
        }
        if (configuration.getModuleType() != null && (parent = configuration.getModuleType().getParent()) != null && parent instanceof Model) {
            configuration = ((Model)parent).getModelConfiguration();
            for (IElement element : configuration.getElements()) {
                if (!(element instanceof Book)) continue;
                for (Sheet sheet : ((Book)element).getSheets()) {
                    if (!r.equals(sheet.getName())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static Variability getVariability(IndependentVariable variable) {
        try {
            if (RepresentationUtils.isPartOfGameExperiment(variable) && !(variable instanceof Stock)) {
                if (variable.getIncomingDependencies() == null || variable.getIncomingDependencies().isEmpty()) {
                    return Variability.getVariability(variable, true, null);
                }
                return Variability.getVariability(variable, false, null);
            }
            return Variability.getVariability(variable, true, null);
        }
        catch (StackOverflowError stackOverflowError) {
            return CONTINUOUS;
        }
    }

    public static Variability getVariability(IndependentVariable variable, boolean allowVariableReferences, Configuration configuration) {
        if (variable == null || variable.getExpressions() == null) {
            return CONTINUOUS;
        }
        ArrayList<IExpression> expressions = variable.getExpressions();
        if (expressions.size() != 1) {
            return CONTINUOUS;
        }
        IExpression ie = expressions.get(0);
        String expression = ie.getExpression();
        return Variability.getVariability(variable, expression, allowVariableReferences, configuration);
    }

    public static Variability getVariability(IndependentVariable variable, String expression) {
        return Variability.getVariability(variable, expression, true, null);
    }

    public static Variability getVariability(IndependentVariable variable, String expression, boolean allowVariableReferences, Configuration configuration) {
        Configuration conf = configuration == null ? variable.getParentConfiguration() : configuration;
        HashMap<Object, Object> functions = new HashMap();
        if (conf != null) {
            Model model = null;
            if (conf.getModuleType() != null) {
                ModuleType moduleType = conf.getModuleType();
                if (moduleType.getParent() instanceof Model) {
                    model = (Model)moduleType.getParent();
                }
            } else {
                model = conf.getModel();
            }
            if (model != null) {
                functions = model.getFunctions();
            }
        }
        String equation = FormatUtils.formatExpressionForModelica(variable, expression, false);
        ExpressionParser parser = new ExpressionParser(new StringReader(equation));
        try {
            parser.expr();
            if (parser.getReferences().isEmpty() && parser.getFunctionCallReferences().isEmpty()) {
                return PARAMETER;
            }
            Set<String> references = parser.getReferences().keySet();
            if (parser.getForIndices() != null) {
                for (Token t : parser.getForIndices().keySet()) {
                    references.remove(t.image);
                }
            }
            for (String function : parser.getFunctionCallReferences().keySet()) {
                if (functions.containsKey(function) && ((Function)functions.get(function)).hasTimeReference()) {
                    return CONTINUOUS;
                }
                if (!timeDependentFunctions.contains(function)) continue;
                return CONTINUOUS;
            }
            for (String reference : references) {
                if (Variability.isParameter(variable, conf, reference, allowVariableReferences)) continue;
                return CONTINUOUS;
            }
            return PARAMETER;
        }
        catch (ParseException parseException) {
            return CONTINUOUS;
        }
    }
}

