/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.util.WeakHashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.sysdyn.manager.SysdynModel;

public class SysdynModelManager {
    WeakHashMap<Resource, SysdynModel> models = new WeakHashMap();
    Session session;

    public SysdynModelManager(Session session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SysdynModel getModel(final Resource resource) {
        WeakHashMap<Resource, SysdynModel> weakHashMap = this.models;
        synchronized (weakHashMap) {
            SysdynModel model = this.models.get(resource);
            if (model == null) {
                try {
                    this.session.syncRequest((Read)new ReadRequest(){

                        public void run(ReadGraph graph) throws DatabaseException {
                            SysdynModel model = new SysdynModel(graph, resource);
                            SysdynModelManager.this.models.put(resource, model);
                        }
                    });
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
                model = this.models.get(resource);
            }
            return model;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SysdynModel getModel(ReadGraph g, Resource resource) {
        WeakHashMap<Resource, SysdynModel> weakHashMap = this.models;
        synchronized (weakHashMap) {
            SysdynModel model = this.models.get(resource);
            if (model == null) {
                model = new SysdynModel(g, resource);
                this.models.put(resource, model);
            }
            return model;
        }
    }

    public static synchronized SysdynModelManager getInstance(Session session) {
        SysdynModelManager manager = (SysdynModelManager)session.peekService(SysdynModelManager.class);
        if (manager == null) {
            manager = new SysdynModelManager(session);
            session.registerService(SysdynModelManager.class, (Object)manager);
        }
        return manager;
    }
}

