/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.util.ArrayList;
import java.util.List;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.spreadsheet.common.matrix.VariantMatrix;
import org.simantics.sysdyn.SysdynResource;

public class HistoryDatasetUtils {
    public static List<String> getVariableNamesInRange(ReadGraph graph, Resource historyData) throws DatabaseException {
        int y;
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        ArrayList<String> values = new ArrayList<String>();
        Resource sheet = graph.getPossibleObject(historyData, sr.HistoryDataset_sheet);
        if (sheet == null) {
            return values;
        }
        String start = (String)graph.getPossibleRelatedValue(historyData, sr.HistoryDataset_start);
        String end = (String)graph.getPossibleRelatedValue(historyData, sr.HistoryDataset_end);
        if (start == null || start.isEmpty() || end == null || end.isEmpty()) {
            return values;
        }
        String r = String.valueOf(start) + ":" + end;
        if (!graph.hasStatement(historyData, sr.HistoryDataset_columns)) {
            return values;
        }
        boolean columns = (Boolean)graph.getRelatedValue(historyData, sr.HistoryDataset_columns, (Binding)Bindings.BOOLEAN);
        Variable v = (Variable)graph.adapt(sheet, Variable.class);
        Variable range = v.getChild(graph, r);
        if (range == null) {
            return values;
        }
        Variant content = (Variant)range.getPropertyValue(graph, "content", (Binding)Bindings.VARIANT);
        Object matrixValue = content.getValue();
        if (!(matrixValue instanceof VariantMatrix)) {
            return values;
        }
        VariantMatrix vm = (VariantMatrix)matrixValue;
        int x = columns ? vm.getColumnCount() : vm.getRowCount();
        int n = y = columns ? vm.getRowCount() : vm.getColumnCount();
        if (vm == null || x < 2 || y < 2) {
            return values;
        }
        int i = 0;
        while (i < x) {
            String name;
            Variant cell;
            Variant variant = cell = columns ? vm.get(0, i) : vm.get(i, 0);
            if (cell != null && cell.getValue() != null && !values.contains(name = cell.getValue().toString())) {
                values.add(name);
            }
            ++i;
        }
        return values;
    }
}

