/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.manager;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.Activator;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynExperiment;

public class FunctionUtils {
    public static List<String> getLibraryPathsForModelica(final SysdynExperiment experiment) {
        try {
            return (List)Simantics.getSession().syncRequest((Read)new Read<List<String>>(){

                public List<String> perform(ReadGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    ArrayList<String> paths = new ArrayList<String>();
                    for (Resource parent : FunctionUtils.getParents(graph, experiment.getModel(), true)) {
                        if (graph.isInstanceOf(parent, sr.SysdynModel)) {
                            String modelName = NameUtils.getSafeName((ReadGraph)graph, (Resource)parent);
                            paths.add(String.valueOf(modelName) + "_functions.mo");
                            continue;
                        }
                        String libraryName = NameUtils.getSafeName((ReadGraph)graph, (Resource)parent);
                        paths.add("..\\\\\\\\..\\\\\\\\libraries\\\\\\\\functions\\\\\\\\" + libraryName + ".mo");
                    }
                    return paths;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void updateFunctionFilesForExperiment(final SysdynExperiment experiment) {
        try {
            Simantics.getSession().syncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    for (Resource parent : FunctionUtils.getParents(graph, experiment.getModel(), false)) {
                        if (graph.isInstanceOf(parent, sr.SysdynModel)) {
                            String parentName = NameUtils.getSafeName((ReadGraph)graph, (Resource)parent);
                            File scriptFile = new File(experiment.getExperimentDir(), String.valueOf(parentName) + "_functions.mo");
                            FunctionUtils.updateFunctionFile(graph, parent, scriptFile, false);
                            continue;
                        }
                        FunctionUtils.updateFunctionFileForLibrary(graph, parent);
                    }
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    private static Set<Resource> getParents(ReadGraph graph, Resource model, boolean ignoreEmpty) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        HashSet<Object> parents = new HashSet<Resource>();
        if (model == null) {
            return parents;
        }
        parents.add(model);
        for (Resource r : graph.getObjects(model, l0.IsLinkedTo)) {
            if (graph.isInstanceOf(r, sr.SharedFunctionOntology)) {
                parents.add(r);
                continue;
            }
            if (((Collection)graph.syncRequest((Read)new ObjectsWithType(r, l0.ConsistsOf, sr.SysdynModelicaFunctionLibrary))).isEmpty()) continue;
            parents.add(r);
        }
        if (ignoreEmpty) {
            HashSet<Resource> nonEmptyParents = new HashSet<Resource>();
            for (Resource resource : parents) {
                if (!FunctionUtils.isNonEmpty(graph, resource)) continue;
                nonEmptyParents.add(resource);
            }
            parents = nonEmptyParents;
        }
        return parents;
    }

    private static boolean isNonEmpty(ReadGraph graph, Resource library) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        if (!((Collection)graph.syncRequest((Read)new ObjectsWithType(library, l0.ConsistsOf, sr.SysdynModelicaFunction))).isEmpty()) {
            return true;
        }
        for (Resource l : (Collection)graph.syncRequest((Read)new ObjectsWithType(library, l0.ConsistsOf, sr.SysdynModelicaFunctionLibrary))) {
            if (!FunctionUtils.isNonEmpty(graph, l)) continue;
            return true;
        }
        return false;
    }

    private static void updateFunctionFile(ReadGraph graph, Resource library, File scriptFile, boolean builtIn) throws DatabaseException {
        PrintStream s;
        try {
            s = new PrintStream(scriptFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)library);
        if (!builtIn && !graph.isInstanceOf(library, sr.SysdynModel)) {
            s.println("package " + name);
        }
        FunctionUtils.writeLibrary(graph, library, scriptFile, s, builtIn);
        if (!builtIn && !graph.isInstanceOf(library, sr.SysdynModel)) {
            s.println("end " + name + ";\n");
        }
        s.close();
    }

    private static void updateFunctionFileForLibrary(ReadGraph graph, Resource library) throws DatabaseException {
        File dir;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        while (!graph.isInstanceOf(library, l0.Ontology)) {
            library = graph.getSingleObject(library, l0.PartOf);
        }
        File librariesDir = Activator.getBundleContext().getDataFile("libraries");
        if (!librariesDir.exists()) {
            librariesDir.mkdir();
        }
        if (!(dir = new File(librariesDir, "functions")).exists()) {
            dir.mkdir();
        }
        String parentName = NameUtils.getSafeName((ReadGraph)graph, (Resource)library);
        File scriptFile = new File(dir, String.valueOf(parentName) + ".mo");
        Resource sysdyn = graph.getResource("http://www.simantics.org/Sysdyn-1.1");
        if (library.equals(sysdyn)) {
            FunctionUtils.updateFunctionFile(graph, library, scriptFile, true);
        } else {
            FunctionUtils.updateFunctionFile(graph, library, scriptFile, false);
        }
    }

    private static void writeLibrary(ReadGraph graph, Resource library, File scriptFile, PrintStream stream, boolean builtIn) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        FunctionUtils.writeLibraryFunctions(graph, library, scriptFile, stream);
        for (Resource sublibrary : (Collection)graph.syncRequest((Read)new ObjectsWithType(library, l0.ConsistsOf, sr.SysdynModelicaFunctionLibrary))) {
            String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)sublibrary);
            boolean xmile = false;
            if (sublibrary.equals(graph.getResource("http://www.simantics.org/Sysdyn-1.1/Built-in%20Functions/Xmile%20Functions"))) {
                xmile = true;
            }
            if (xmile) {
                stream.println("encapsulated package XMILE");
            }
            if (!builtIn) {
                stream.println("encapsulated package " + name);
            }
            FunctionUtils.writeLibrary(graph, sublibrary, scriptFile, stream, builtIn);
            if (!builtIn) {
                stream.println("end " + name + ";\n");
            }
            if (!xmile) continue;
            stream.println("end XMILE;\n");
        }
    }

    private static void writeLibraryFunctions(ReadGraph graph, Resource library, File scriptFile, PrintStream stream) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        for (Resource function : (Collection)graph.syncRequest((Read)new ObjectsWithType(library, l0.ConsistsOf, sr.SysdynModelicaFunction))) {
            String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)function);
            String functionCode = (String)graph.getPossibleRelatedValue(function, sr.SysdynModelicaFunction_modelicaFunctionCode);
            if (functionCode == null) continue;
            stream.println("function " + name);
            stream.println(functionCode);
            stream.println("end " + name + ";\n");
            for (Resource externalFunction : (Collection)graph.syncRequest((Read)new ObjectsWithType(function, l0.ConsistsOf, sr.ExternalFunctionFile))) {
                FunctionUtils.createExternalFunctionFile(graph, externalFunction, scriptFile);
            }
        }
    }

    private static void createExternalFunctionFile(ReadGraph graph, Resource externalFunction, File scriptFile) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        File dir = scriptFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (!dir.isDirectory()) {
            return;
        }
        try {
            String name = NameUtils.getSafeName((ReadGraph)graph, (Resource)externalFunction);
            if (name.endsWith(".o") || name.endsWith(".a")) {
                FileOutputStream fos = new FileOutputStream(dir + File.separator + name);
                byte[] fileBArray = (byte[])graph.getPossibleRelatedValue(externalFunction, sr.ExternalFunctionFile_externalFile, (Binding)Bindings.BYTE_ARRAY);
                fos.write(fileBArray);
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

