/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.generator.IGenerator;

public class RandomGenerator
implements IGenerator {
    private int seed;
    private int dimension;
    private Random random;

    public RandomGenerator(ReadGraph graph, Resource method) {
        try {
            SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
            Resource experiment = graph.getPossibleObject(method, SR.SensitivityAnalysisExperiment_method_Inverse);
            this.seed = (Integer)graph.getPossibleRelatedValue(experiment, SR.SensitivityAnalysisExperiment_randomSeed, (Binding)Bindings.INTEGER);
            Resource parameterListResource = graph.getPossibleObject(experiment, SR.SensitivityAnalysisExperiment_parameterList);
            this.dimension = ListUtils.getListNodes((ReadGraph)graph, (Resource)parameterListResource).size();
            this.initialize();
        }
        catch (DatabaseException databaseException) {}
    }

    @Override
    public List<Double> next() {
        ArrayList<Double> randoms = new ArrayList<Double>();
        int i = 0;
        while (i < this.dimension) {
            randoms.add(this.random.nextDouble());
            ++i;
        }
        return randoms;
    }

    @Override
    public void initialize() {
        this.random = new Random(this.seed);
    }
}

