/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter.generator;

import java.util.ArrayList;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.generator.IGenerator;

public class HaltonSequenceGenerator
implements IGenerator {
    private int dimension;
    private int index = 0;
    private ArrayList<Integer> primes;

    private void getPrimes() {
        int newPrime = 2;
        while (this.primes.size() < this.dimension) {
            boolean isPrime = true;
            for (int p : this.primes) {
                if (newPrime % p != 0) continue;
                ++newPrime;
                isPrime = false;
                break;
            }
            if (!isPrime) continue;
            this.primes.add(newPrime);
        }
    }

    public HaltonSequenceGenerator(ReadGraph graph, Resource method) {
        try {
            SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
            Resource experiment = graph.getPossibleObject(method, SR.SensitivityAnalysisExperiment_method_Inverse);
            Resource parameterListResource = graph.getPossibleObject(experiment, SR.SensitivityAnalysisExperiment_parameterList);
            this.dimension = ListUtils.getListNodes((ReadGraph)graph, (Resource)parameterListResource).size();
            this.primes = new ArrayList();
            this.getPrimes();
            this.initialize();
        }
        catch (DatabaseException databaseException) {}
    }

    public static double getHalton(int index, int base) {
        ++index;
        double result = 0.0;
        double f = 1.0 / (double)base;
        while (index > 0) {
            result += f * (double)(index % base);
            index /= base;
            f /= (double)base;
        }
        return result;
    }

    @Override
    public List<Double> next() {
        ArrayList<Double> retval = new ArrayList<Double>();
        int i = 0;
        while (i < this.dimension) {
            int base = this.primes.get(i);
            double halton = HaltonSequenceGenerator.getHalton(this.index, base);
            retval.add(halton);
            ++i;
        }
        ++this.index;
        return retval;
    }

    @Override
    public void initialize() {
        this.index = 0;
    }
}

