/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import java.util.Arrays;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.sysdyn.adapter.ValueIndexVariableBase;

public class ValueIndexVariableI
extends ValueIndexVariableBase<Double> {
    final int index;

    public ValueIndexVariableI(ReadGraph graph, Variable parent, int index) throws DatabaseException {
        super(graph, parent, "");
        this.index = index;
    }

    @Override
    public Double getValue() {
        double[] array = this.getValueFull();
        if (array == null || this.index < 0 || array.length < this.index + 1) {
            return Double.NaN;
        }
        return array[this.index];
    }

    @Override
    public void setValue(WriteGraph graph, Object value) throws DatabaseException {
        this.ensureInformationAvailable((ReadGraph)graph);
        double[] existing = this.getValueFull();
        double[] newValue = Arrays.copyOf(existing, existing.length);
        newValue[this.index] = (Double)value;
        super.setValue(graph, newValue);
    }

    @Override
    public void setValue(WriteGraph graph, Object value, Binding binding) throws DatabaseException {
        this.setValue(graph, value);
    }

    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return "$" + this.index;
    }

    @Override
    public Datatype getDatatype(ReadGraph graph) throws DatabaseException {
        return Datatypes.DOUBLE;
    }
}

