/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.adapter;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.adapter.distribution.IDistribution;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.representation.Enumeration;
import org.simantics.sysdyn.representation.Variable;
import org.simantics.sysdyn.representation.utils.IndexUtils;
import org.simantics.sysdyn.representation.utils.RepresentationUtils;

public class SensitivityExperimentParameter {
    private String variableName;
    private String[] indexes;
    private String fullName;
    private IDistribution distribution;

    public SensitivityExperimentParameter(ReadGraph graph, Resource parameter) {
        try {
            SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
            Resource distributionResource = graph.getPossibleObject(parameter, SR.SensitivityAnalysisExperiment_Parameter_propabilityDistribution);
            this.distribution = (IDistribution)graph.adapt(distributionResource, IDistribution.class);
            this.variableName = (String)graph.getPossibleRelatedValue(parameter, SR.SensitivityAnalysisExperiment_Parameter_variable, (Binding)Bindings.STRING);
            this.indexes = (String[])graph.getPossibleRelatedValue(parameter, SR.SensitivityAnalysisExperiment_Parameter_indexes, (Binding)Bindings.STRING_ARRAY);
            Resource model = (Resource)graph.syncRequest((Read)new PossibleModel(parameter));
            SysdynModelManager smm = SysdynModelManager.getInstance(graph.getSession());
            SysdynModel sm = smm.getModel(graph, graph.getPossibleObject(model, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration));
            Variable variable = RepresentationUtils.getVariable(sm.getConfiguration(), this.variableName);
            if (variable != null) {
                if (this.indexes == null && variable.getArrayIndexes() != null & variable.getArrayIndexes().size() > 0) {
                    this.indexes = new String[variable.getArrayIndexes().size()];
                    int i = 0;
                    while (i < variable.getArrayIndexes().size()) {
                        Enumeration e = variable.getArrayIndexes().get(i);
                        this.indexes[i] = e.getEnumerationIndexes().get(0).getName();
                        ++i;
                    }
                }
                if (this.indexes != null) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("[");
                    int i = 0;
                    while (i < this.indexes.length) {
                        if (i > 0) {
                            sb.append(",");
                        }
                        String index = this.indexes[i];
                        sb.append(index);
                        ++i;
                    }
                    sb.append("]");
                    String result = IndexUtils.rangeToIndexes(variable, sb.toString());
                    this.fullName = String.valueOf(this.variableName) + result;
                } else {
                    this.fullName = this.variableName;
                }
            }
        }
        catch (DatabaseException databaseException) {}
    }

    public String getVariableName() {
        return this.variableName;
    }

    public String[] getIndexes() {
        return this.indexes;
    }

    public String getFullName() {
        return this.fullName;
    }

    public IDistribution getDistribution() {
        return this.distribution;
    }

    public String getFullModelicaName() {
        if (this.fullName == null) {
            return null;
        }
        return this.fullName.replace(' ', '_');
    }
}

