/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.xmile;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import org.simantics.sysdyn.modelImport.IModelParser;
import org.simantics.sysdyn.modelImport.model.Cloud;
import org.simantics.sysdyn.modelImport.model.Connection;
import org.simantics.sysdyn.modelImport.model.Dependency;
import org.simantics.sysdyn.modelImport.model.Symbol;
import org.simantics.sysdyn.modelImport.model.Valve;
import org.simantics.sysdyn.modelImport.model.Variable;
import org.simantics.sysdyn.modelImport.model.expression.EnumerationExpression;
import org.simantics.sysdyn.modelImport.model.expression.Expression;
import org.simantics.sysdyn.modelImport.model.expression.IntegralExpression;
import org.simantics.sysdyn.modelImport.model.expression.LookupExpression;
import org.simantics.sysdyn.modelImport.model.expression.NormalExpression;
import org.simantics.sysdyn.modelImport.model.support.Enumeration;
import org.simantics.sysdyn.xmile.XmileUtil;
import org.simantics.sysdyn.xmile.expressionParser.XmileExpressionParser;
import org.simantics.sysdyn.xmile.schema.Auxiliary;
import org.simantics.sysdyn.xmile.schema.Dimensions;
import org.simantics.sysdyn.xmile.schema.Flow;
import org.simantics.sysdyn.xmile.schema.Gf;
import org.simantics.sysdyn.xmile.schema.Header;
import org.simantics.sysdyn.xmile.schema.Includes;
import org.simantics.sysdyn.xmile.schema.MinMaxType;
import org.simantics.sysdyn.xmile.schema.Model;
import org.simantics.sysdyn.xmile.schema.ModelUnits;
import org.simantics.sysdyn.xmile.schema.PointsType;
import org.simantics.sysdyn.xmile.schema.SimSpecs;
import org.simantics.sysdyn.xmile.schema.Stock;
import org.simantics.sysdyn.xmile.schema.ViewContentType;
import org.simantics.sysdyn.xmile.schema.Views;
import org.simantics.sysdyn.xmile.schema.Xmile;
import org.simantics.sysdyn.xmile.unitParser.XmileUnitParser;

public class XmileParser
implements IModelParser {
    private static final String EQUATION = "eqn";
    private static final String INFLOW = "inflow";
    private static final String OUTFLOW = "outflow";
    private static final String UNITS = "units";
    private static final String ELEMENT = "element";
    private static final String DOC = "doc";
    private static final double DEFAULT_X = 1.0;
    private static final double DEFAULT_Y = 1.0;
    private static final double DEFAULT_ANGLE = 1.0;
    private org.simantics.sysdyn.modelImport.model.Model model;
    private Map<String, String> unitMap = new HashMap<String, String>();
    private boolean arrays = true;

    public org.simantics.sysdyn.modelImport.model.Model parse(File file) throws Exception {
        JAXBContext context = JAXBContext.newInstance((String)"org.simantics.sysdyn.xmile.schema");
        Unmarshaller unmarshaller = context.createUnmarshaller();
        Xmile xmile = (Xmile)unmarshaller.unmarshal(file);
        String name = XmileUtil.normalize(file.getName().replaceAll("\\.\\w+$", ""));
        this.model = new org.simantics.sysdyn.modelImport.model.Model(name);
        this.parseDocument(xmile);
        return this.model;
    }

    private org.simantics.sysdyn.modelImport.model.Model parseDocument(Xmile xmile) throws Exception {
        Xmile.Dimensions dimensionsObj;
        ModelUnits unitsObj;
        List<Object> objs = xmile.getSimSpecsOrModelUnitsOrBehavior();
        this.parseHeader(xmile.getHeader());
        SimSpecs specsObj = this.getPossibleElement(SimSpecs.class, objs);
        if (specsObj != null) {
            this.parseSimSpecs(specsObj);
        }
        if ((unitsObj = this.getPossibleElement(ModelUnits.class, objs)) != null) {
            this.parseModelUnits(unitsObj);
        }
        if ((dimensionsObj = this.getPossibleElement(Xmile.Dimensions.class, objs)) != null) {
            this.parseDimensions(dimensionsObj);
        }
        List<Model> modelObjs = this.getElements(Model.class, objs);
        for (Model modelObj : modelObjs) {
            if (modelObj.getName() != null) continue;
            this.parseModel(modelObj);
        }
        return this.model;
    }

    private void parseHeader(Header header) throws Exception {
        String name = header.getName();
        if (name != null) {
            this.model.setName(XmileUtil.normalize(name.replaceAll("\\.\\w+$", "")));
        }
        if (header.getIncludes() != null) {
            for (Includes.Include include : header.getIncludes().getInclude()) {
                this.parseInclude(include);
            }
        }
    }

    private void parseInclude(Includes.Include include) {
        System.err.println("INCLUDE");
    }

    private void parseSimSpecs(SimSpecs specsObj) throws Exception {
        this.model.setStartTime(specsObj.getStart());
        this.model.setStopTime(specsObj.getStop());
        double step = 1.0;
        if (specsObj.getDt() != null) {
            step = specsObj.getDt().getValue();
        }
        this.model.setTimeStep(step);
        specsObj.getMethod();
        String unit = specsObj.getTimeUnits();
        if (unit != null) {
            this.model.setTimeUnit(unit);
        }
    }

    private void parseModelUnits(ModelUnits unitsObj) throws Exception {
        int n;
        String name;
        for (ModelUnits.Unit unit : unitsObj.getUnit()) {
            if (unit.getEqn() != null) continue;
            name = unit.getName();
            this.unitMap.put(name.toUpperCase(), name);
            for (String alias : unit.getAlias()) {
                String[] stringArray = alias.split(",");
                n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String a = stringArray[n2];
                    this.unitMap.put(a.toUpperCase(), name);
                    ++n2;
                }
            }
        }
        for (ModelUnits.Unit unit : unitsObj.getUnit()) {
            if (unit.getEqn() == null) continue;
            name = unit.getName();
            String equation = XmileUnitParser.parse(unit.getEqn(), this.unitMap);
            this.unitMap.put(name.toUpperCase(), equation);
            for (String alias : unit.getAlias()) {
                String[] stringArray = alias.split(",");
                int n3 = stringArray.length;
                n = 0;
                while (n < n3) {
                    String a = stringArray[n];
                    this.unitMap.put(a.toUpperCase(), equation);
                    ++n;
                }
            }
        }
    }

    private void parseDimensions(Xmile.Dimensions dimensionsObj) throws Exception {
        for (Xmile.Dimensions.Dim dim : dimensionsObj.getDim()) {
            String name = dim.getName();
            ArrayList<String> values = new ArrayList<String>();
            if (dim.getSize() != null) {
                int i = 0;
                while (i < dim.getSize()) {
                    values.add("index" + i);
                    ++i;
                }
            } else {
                for (Xmile.Dimensions.Dim.Elem elem : dim.getElem()) {
                    values.add(elem.getName());
                }
            }
            this.model.addEnumeration(new Enumeration(name, values));
        }
    }

    private void parseModel(Model modelObj) throws Exception {
        List<Object> vars = modelObj.getVariables().getStockOrFlowOrAuxiliary();
        for (Auxiliary auxObj : this.getElements(Auxiliary.class, vars)) {
            this.model.addVariable((Variable)this.getAux(auxObj));
        }
        for (Flow flowObj : this.getElements(Flow.class, vars)) {
            this.model.addVariable((Variable)this.getFlow(flowObj));
        }
        for (Stock stockObj : this.getElements(Stock.class, vars)) {
            org.simantics.sysdyn.modelImport.model.Stock stock = this.getStock(stockObj);
            this.model.addVariable((Variable)stock);
            for (String in : this.getJAXBElements(String.class, INFLOW, stockObj.getEqnOrMathmlOrUnits())) {
                Variable from = this.model.getVariable(XmileUtil.normalize(in));
                this.model.addConnection((Connection)new org.simantics.sysdyn.modelImport.model.Flow((Symbol)from, (Symbol)stock));
            }
            for (String out : this.getJAXBElements(String.class, OUTFLOW, stockObj.getEqnOrMathmlOrUnits())) {
                Variable to = this.model.getVariable(XmileUtil.normalize(out));
                this.model.addConnection((Connection)new org.simantics.sysdyn.modelImport.model.Flow((Symbol)stock, (Symbol)to));
            }
        }
        if (modelObj.getViews() != null) {
            for (Views.View view : this.getElements(Views.View.class, modelObj.getViews().getStyleOrView())) {
                this.parseView(view);
            }
        }
        modelObj.getSimSpecs();
    }

    private void parseView(Views.View view) {
        Double y;
        Double x;
        List<Object> objs = view.getStyleOrStockOrFlow();
        for (ViewContentType.Stock stockObj : this.getElements(ViewContentType.Stock.class, objs)) {
            org.simantics.sysdyn.modelImport.model.Stock stock = (org.simantics.sysdyn.modelImport.model.Stock)this.model.getVariable(XmileUtil.normalize(stockObj.getName()));
            x = stockObj.getX();
            y = stockObj.getY();
            stock.setX(x != null ? x : 1.0);
            stock.setY(y != null ? y : 1.0);
        }
        for (ViewContentType.Flow flowObj : this.getElements(ViewContentType.Flow.class, objs)) {
            Cloud cloud;
            Valve valve = (Valve)this.model.getVariable(XmileUtil.normalize(flowObj.getName()));
            x = flowObj.getX();
            y = flowObj.getY();
            valve.setX(x != null ? x : 1.0);
            valve.setY(y != null ? y : 1.0);
            List<ViewContentType.Flow.Pts.Pt> points = flowObj.getPts().getPt();
            if (this.model.getInFlows((Variable)valve).isEmpty()) {
                ViewContentType.Flow.Pts.Pt first = points.get(0);
                cloud = new Cloud(new double[]{first.getX(), first.getY(), 0.0, 0.0});
                this.model.addSymbol((Symbol)cloud);
                this.model.addConnection((Connection)new org.simantics.sysdyn.modelImport.model.Flow((Symbol)cloud, (Symbol)valve));
            }
            if (!this.model.getOutFlows((Variable)valve).isEmpty()) continue;
            ViewContentType.Flow.Pts.Pt last = points.get(points.size() - 1);
            cloud = new Cloud(new double[]{last.getX(), last.getY(), 0.0, 0.0});
            this.model.addSymbol((Symbol)cloud);
            this.model.addConnection((Connection)new org.simantics.sysdyn.modelImport.model.Flow((Symbol)valve, (Symbol)cloud));
        }
        for (ViewContentType.Aux auxObj : this.getElements(ViewContentType.Aux.class, objs)) {
            org.simantics.sysdyn.modelImport.model.Auxiliary aux = (org.simantics.sysdyn.modelImport.model.Auxiliary)this.model.getVariable(XmileUtil.normalize(auxObj.getName()));
            x = auxObj.getX();
            y = auxObj.getY();
            aux.setX(x != null ? x : 1.0);
            aux.setY(y != null ? y : 1.0);
        }
        for (ViewContentType.Connector connector : this.getElements(ViewContentType.Connector.class, objs)) {
            String fromName = XmileUtil.normalize((String)((Object)connector.getFrom().getContent().get(0)));
            String toName = XmileUtil.normalize(connector.getTo());
            Variable from = this.model.getVariable(fromName);
            Variable to = this.model.getVariable(toName);
            this.model.addConnection((Connection)new Dependency((Symbol)from, (Symbol)to, true, false, 1.0));
        }
    }

    private org.simantics.sysdyn.modelImport.model.Stock getStock(Stock stockObj) throws Exception {
        List<Object> objs = stockObj.getEqnOrMathmlOrUnits();
        org.simantics.sysdyn.modelImport.model.Stock stock = new org.simantics.sysdyn.modelImport.model.Stock();
        stock.setName(XmileUtil.normalize(stockObj.getName()));
        String doc = this.getPossibleJAXBElement(String.class, DOC, objs);
        if (doc != null) {
            stock.setDescription(doc);
        }
        StringBuilder expression = new StringBuilder();
        for (String in : this.getJAXBElements(String.class, INFLOW, objs)) {
            expression.append('+').append(XmileUtil.normalize(in));
        }
        for (String out : this.getJAXBElements(String.class, OUTFLOW, objs)) {
            expression.append('-').append(XmileUtil.normalize(out));
        }
        Expression expr = this.parseExpression(objs, VariableType.STOCK, expression.toString());
        stock.setExpression(expr);
        String units = this.getPossibleJAXBElement(String.class, UNITS, objs);
        if (units != null) {
            stock.setUnit(XmileUnitParser.parse(units, this.unitMap));
        }
        stock.setX(1.0);
        stock.setY(1.0);
        return stock;
    }

    private Valve getFlow(Flow flowObj) throws Exception {
        List<Object> objs = flowObj.getEqnOrMathmlOrUnits();
        Valve valve = new Valve();
        valve.setName(XmileUtil.normalize(flowObj.getName()));
        String doc = this.getPossibleJAXBElement(String.class, DOC, objs);
        if (doc != null) {
            valve.setDescription(doc);
        }
        Expression expr = this.parseExpression(objs, VariableType.FLOW, null);
        valve.setExpression(expr);
        String units = this.getPossibleJAXBElement(String.class, UNITS, objs);
        if (units != null) {
            valve.setUnit(XmileUnitParser.parse(units, this.unitMap));
        }
        valve.setX(1.0);
        valve.setY(1.0);
        return valve;
    }

    private org.simantics.sysdyn.modelImport.model.Auxiliary getAux(Auxiliary auxObj) throws Exception {
        List<Object> objs = auxObj.getEqnOrMathmlOrUnits();
        org.simantics.sysdyn.modelImport.model.Auxiliary aux = new org.simantics.sysdyn.modelImport.model.Auxiliary();
        aux.setName(XmileUtil.normalize(auxObj.getName()));
        String doc = this.getPossibleJAXBElement(String.class, DOC, objs);
        if (doc != null) {
            aux.setDescription(doc);
        }
        Expression expr = this.parseExpression(objs, VariableType.AUX, null);
        aux.setExpression(expr);
        String units = this.getPossibleJAXBElement(String.class, UNITS, objs);
        if (units != null) {
            aux.setUnit(XmileUnitParser.parse(units, this.unitMap));
        }
        aux.setX(1.0);
        aux.setY(1.0);
        return aux;
    }

    private Expression parseExpression(List<Object> objs, VariableType type, String additional) throws Exception {
        String equation = this.getPossibleJAXBElement(String.class, EQUATION, objs);
        Gf gf = this.getPossibleElement(Gf.class, objs);
        Dimensions dimensions = this.getPossibleElement(Dimensions.class, objs);
        if (dimensions != null) {
            Class elementType;
            ArrayList<Enumeration> enums = new ArrayList<Enumeration>();
            for (Dimensions.Dim dim : dimensions.getDim()) {
                enums.add(this.model.getEnumeration(dim.getName()));
            }
            EnumerationExpression expr = new EnumerationExpression(enums);
            switch (type) {
                case STOCK: {
                    elementType = Stock.Element.class;
                    break;
                }
                case FLOW: {
                    elementType = Flow.Element.class;
                    break;
                }
                case AUX: {
                    elementType = Auxiliary.Element.class;
                    break;
                }
                default: {
                    throw new Exception("unrecognized variable type " + (Object)((Object)type));
                }
            }
            List<Stock.Element> elements = this.getJAXBElements(elementType, ELEMENT, objs);
            if (!elements.isEmpty()) {
                for (Stock.Element element : elements) {
                    String subscript;
                    List<Object> elementObjs;
                    switch (type) {
                        case STOCK: {
                            Stock.Element stockElement = element;
                            elementObjs = stockElement.getEqnOrMathmlOrGf();
                            subscript = stockElement.getSubscript();
                            break;
                        }
                        case FLOW: {
                            Flow.Element flowElement = (Flow.Element)((Object)element);
                            elementObjs = flowElement.getEqnOrMathmlOrGf();
                            subscript = flowElement.getSubscript();
                            break;
                        }
                        case AUX: {
                            Auxiliary.Element auxElement = (Auxiliary.Element)((Object)element);
                            elementObjs = auxElement.getEqnOrMathmlOrGf();
                            subscript = auxElement.getSubscript();
                            break;
                        }
                        default: {
                            throw new Exception("unrecognized variable type " + (Object)((Object)type));
                        }
                    }
                    String elementEquation = this.getPossibleJAXBElement(String.class, EQUATION, elementObjs);
                    Gf elementGf = this.getPossibleElement(Gf.class, elementObjs);
                    String[] elementIndices = subscript.split(",");
                    int i = 0;
                    while (i < elementIndices.length) {
                        try {
                            int index = Integer.parseInt(elementIndices[i]);
                            elementIndices[i] = (String)((Enumeration)enums.get(i)).getValues().get(index - 1);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        ++i;
                    }
                    if (elementEquation == null) {
                        if (elementGf != null) {
                            elementEquation = equation;
                        } else {
                            throw new Exception("non-graphical non-apply-to-all array element equation not found");
                        }
                    }
                    elementEquation = XmileExpressionParser.parse(elementEquation, null);
                    expr.addExpression(this.getExpression(elementEquation, elementGf, type, additional), elementIndices);
                }
            } else {
                EnumIterator iter = new EnumIterator(enums);
                while (iter.hasNext()) {
                    String[] elementIndices = iter.next();
                    String elementEquation = XmileExpressionParser.parse(equation, null);
                    expr.addExpression(this.getExpression(elementEquation, gf, type, additional), elementIndices);
                }
            }
            return expr;
        }
        equation = XmileExpressionParser.parse(equation, null);
        return this.getExpression(equation, gf, type, additional);
    }

    private Expression getExpression(String equation, Gf gf, VariableType type, String additional) throws Exception {
        if (equation == null) {
            throw new Exception("no equation for " + (Object)((Object)type) + " variable");
        }
        switch (type) {
            case STOCK: {
                if (additional == null) {
                    throw new Exception("no integral for stock");
                }
                return new IntegralExpression(additional, equation);
            }
            case FLOW: 
            case AUX: {
                if (gf != null) {
                    return this.getLookupExpression(equation, gf);
                }
                return new NormalExpression(equation);
            }
        }
        throw new Exception("unrecognized variable type " + (Object)((Object)type));
    }

    private LookupExpression getLookupExpression(String equation, Gf gf) {
        PointsType xPts = gf.getXpts();
        PointsType yPts = gf.getYpts();
        MinMaxType xScale = gf.getXscale();
        MinMaxType yScale = gf.getYscale();
        double[] y = this.getPointsArray(yPts);
        double[] x = xPts != null ? this.getPointsArray(xPts) : this.getPointsArray(xScale, y.length);
        double[] points = new double[y.length * 2];
        int i = 0;
        while (i < y.length) {
            points[2 * i] = x[i];
            points[2 * i + 1] = y[i];
            ++i;
        }
        double xMin = xScale != null ? xScale.getMin().doubleValue() : this.getMinValue(x);
        double yMin = yScale != null ? yScale.getMin().doubleValue() : this.getMinValue(y);
        double xMax = xScale != null ? xScale.getMax().doubleValue() : this.getMaxValue(x);
        double yMax = yScale != null ? yScale.getMax().doubleValue() : this.getMaxValue(y);
        return new LookupExpression(equation, xMin, yMin, xMax, yMax, points);
    }

    private double[] getPointsArray(PointsType points) {
        String[] tmp = points.getValue().split(points.getSep());
        double[] res = new double[tmp.length];
        int i = 0;
        while (i < tmp.length) {
            res[i] = Double.parseDouble(tmp[i]);
            ++i;
        }
        return res;
    }

    private double[] getPointsArray(MinMaxType scale, int size) {
        double[] res = new double[size];
        double min = scale.getMin();
        double max = scale.getMax();
        double interval = (max - min) / (double)(size - 1);
        int i = 0;
        while (i < size) {
            res[i] = min + (double)i * interval;
            ++i;
        }
        return res;
    }

    private double getMaxValue(double[] values) {
        double max = values[0];
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            if (value > max) {
                max = value;
            }
            ++n2;
        }
        return max;
    }

    private double getMinValue(double[] values) {
        double min = values[0];
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double value = dArray[n2];
            if (value < min) {
                min = value;
            }
            ++n2;
        }
        return min;
    }

    private <T> T getPossibleElement(Class<T> type, List<Object> objects) {
        for (Object obj : objects) {
            if (!obj.getClass().equals(type)) continue;
            return (T)obj;
        }
        return null;
    }

    private <T> List<T> getElements(Class<T> type, List<Object> objects) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (Object obj : objects) {
            if (!obj.getClass().equals(type)) continue;
            elements.add(obj);
        }
        return elements;
    }

    private <T> T getPossibleJAXBElement(Class<T> type, String name, List<Object> objects) {
        for (JAXBElement je : this.getElements(JAXBElement.class, objects)) {
            if (!je.getName().getLocalPart().equals(name) || !je.getDeclaredType().equals(type)) continue;
            return (T)je.getValue();
        }
        return null;
    }

    private <T> List<T> getJAXBElements(Class<T> type, String name, List<Object> objects) {
        ArrayList<Object> elements = new ArrayList<Object>();
        for (JAXBElement je : this.getElements(JAXBElement.class, objects)) {
            if (!je.getName().getLocalPart().equals(name) || !je.getDeclaredType().equals(type)) continue;
            elements.add(je.getValue());
        }
        return elements;
    }

    private class EnumIterator
    implements Iterator<String[]> {
        private List<Enumeration> enums;
        private int[] indices;
        private boolean done;

        public EnumIterator(List<Enumeration> enums) {
            this.enums = enums;
            this.indices = new int[enums.size()];
            this.done = false;
            for (Enumeration e : enums) {
                if (e.getValues().size() != 0) continue;
                this.done = true;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public String[] next() {
            String[] result = new String[this.indices.length];
            int i = 0;
            while (i < this.indices.length) {
                result[i] = (String)this.enums.get(i).getValues().get(this.indices[i]);
                ++i;
            }
            boolean next = false;
            int i2 = this.indices.length - 1;
            while (i2 >= 0) {
                this.indices[i2] = (this.indices[i2] + 1) % this.enums.get(i2).getValues().size();
                if (this.indices[i2] > 0) {
                    next = true;
                    break;
                }
                --i2;
            }
            this.done = !next;
            return result;
        }

        @Override
        public void remove() {
        }
    }

    private static enum VariableType {
        STOCK,
        FLOW,
        AUX;

    }
}

