/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.wizards.modules;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.simantics.browsing.ui.swt.AdaptableHintContext;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.sysdyn.ui.utils.imports.ImportUtilsUI;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.ArrayMap;

public class WizardModulesImportPage
extends WizardPage {
    public static String IMPORTMODULETPATH = "IMPORT_MODULE_PATH";
    private Text filePathField;
    private static String previouslyBrowsedFile = "";
    private Button browseDirectoriesButton;
    private Shell shell;
    private Resource selectedModel;
    GraphExplorerComposite modelExplorer;
    private boolean selectionMade = false;

    public WizardModulesImportPage() {
        this("wizardModulesImportPage", null, null);
    }

    public WizardModulesImportPage(String pageName) {
        this(pageName, null, null);
    }

    public WizardModulesImportPage(String pageName, String initialPath, IStructuredSelection currentSelection) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle("Import Module");
        this.setDescription("Choose the Module file and the import location, then press Finish.");
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        this.createTree(workArea);
    }

    private void createProjectsRoot(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText("Select Module source:");
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        this.filePathField = new Text(projectGroup, 2048);
        GridData directoryPathData = new GridData(4, 0, true, false);
        directoryPathData.widthHint = new PixelConverter((Control)this.filePathField).convertWidthInCharsToPixels(25);
        this.filePathField.setLayoutData((Object)directoryPathData);
        this.filePathField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                previouslyBrowsedFile = WizardModulesImportPage.this.filePathField.getText();
            }
        });
        if (previouslyBrowsedFile != null) {
            this.filePathField.setText(previouslyBrowsedFile);
            this.validatePage();
        }
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText("Browse");
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardModulesImportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
    }

    private void createTree(Composite workArea) {
        Label title = new Label(workArea, 0);
        title.setText("Select import location:");
        try {
            Resource input = (Resource)SimanticsUI.getSession().syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    Resource model = (Resource)SimanticsUI.getProject().get();
                    return model;
                }
            });
            this.modelExplorer = new GraphExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), null, workArea, 2052);
            this.modelExplorer.setBrowseContexts(new String[]{"http://www.simantics.org/Sysdyn-1.1/ImportModuleTree"});
            this.modelExplorer.finish();
            this.modelExplorer.setInput(null, (Object)input);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.modelExplorer);
            ((Tree)this.modelExplorer.getExplorer().getControl()).addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    WizardModulesImportPage.this.selectionMade = true;
                    WizardModulesImportPage.this.validatePage();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    WizardModulesImportPage.this.selectionMade = true;
                    WizardModulesImportPage.this.validatePage();
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.filePathField.setFocus();
    }

    protected void handleLocationDirectoryButtonPressed() {
        String selectedFile;
        this.shell = this.filePathField.getShell();
        FileDialog dialog = new FileDialog(this.shell, 4096);
        String[] ext = new String[]{"*.sysdynModule; *.tg", "*.*"};
        dialog.setFilterExtensions(ext);
        dialog.setText("Import Module");
        String dirName = this.filePathField.getText().trim();
        File path = new File(dirName);
        if (path.exists()) {
            dialog.setFilterPath(new Path(dirName).toOSString());
        }
        if ((selectedFile = dialog.open()) != null) {
            this.filePathField.setText(selectedFile);
            this.validatePage();
        }
    }

    public static <T> T getExplorerResource(GraphExplorerComposite explorer, Class<T> clazz) {
        if (explorer == null) {
            return null;
        }
        ISelection selection = ((ISelectionProvider)explorer.getAdapter(ISelectionProvider.class)).getSelection();
        if (selection == null) {
            return null;
        }
        IStructuredSelection iss = (IStructuredSelection)selection;
        AdaptableHintContext inc = (AdaptableHintContext)iss.getFirstElement();
        if (inc == null) {
            return null;
        }
        Object resource = inc.getAdapter(clazz);
        return (T)resource;
    }

    public boolean createProjects() {
        String selected = previouslyBrowsedFile;
        if (selected == null) {
            this.setErrorMessage("Error when retrieving resource");
            return false;
        }
        this.selectedModel = WizardModulesImportPage.getExplorerResource(this.modelExplorer, Resource.class);
        if (this.selectedModel == null) {
            this.setErrorMessage("No file selected");
            return false;
        }
        IStatus status = ImportUtilsUI.importModuleFile(this.selectedModel, selected, null);
        if (status == null || !status.equals(Status.OK_STATUS)) {
            this.setErrorMessage(status.getMessage());
            return false;
        }
        return true;
    }

    void validatePage() {
        if (previouslyBrowsedFile.isEmpty() || !this.selectionMade) {
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }
}

