/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.wizards.model;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Deque;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.Simantics;
import org.simantics.db.management.ISessionContext;
import org.simantics.graph.db.MissingDependencyException;
import org.simantics.modeling.ui.utils.NoProjectPage;
import org.simantics.sysdyn.ui.utils.imports.ImportUtilsUI;
import org.simantics.sysdyn.ui.wizards.Preferences;
import org.simantics.sysdyn.ui.wizards.model.SysdynImportModel;
import org.simantics.sysdyn.ui.wizards.model.SysdynModelImportPage;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ExceptionUtils;

public class SysdynModelImportWizard
extends Wizard
implements IImportWizard {
    private static final int MAX_RECENT_IMPORT_PATHS = 10;
    private SysdynImportModel importModel;

    public SysdynModelImportWizard() {
        this.setWindowTitle("Import Sysdyn Model");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.readPreferences(selection);
    }

    public void addPages() {
        super.addPages();
        if (this.importModel != null) {
            this.addPage((IWizardPage)new SysdynModelImportPage(this.importModel));
        } else {
            this.addPage((IWizardPage)new NoProjectPage("Import Sysdyn Model"));
        }
    }

    public boolean performFinish() {
        try {
            this.importModel.getRecentLocations().addFirst(this.importModel.getImportLocation().getAbsolutePath());
            Preferences.removeDuplicates(this.importModel.getRecentLocations());
            if (this.importModel.getRecentLocations().size() > 10) {
                this.importModel.getRecentLocations().pollLast();
            }
            this.writePreferences();
        }
        catch (IOException e) {
            ErrorLogger.defaultLogError((String)"Failed to write preferences", (Throwable)e);
        }
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            ImportUtilsUI.importModelFile(SysdynModelImportWizard.this.importModel.getImportLocation().getAbsolutePath(), monitor);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof OperationCanceledException) {
                return false;
            }
            WizardPage cp = (WizardPage)this.getContainer().getCurrentPage();
            ErrorLogger.defaultLogError((Throwable)t);
            if (t instanceof IOException) {
                cp.setErrorMessage("An I/O problem occurred while importing Sysdyn model.\n\nMessage: " + e.getMessage());
            } else if (t instanceof MissingDependencyException) {
                cp.setErrorMessage("The import target project is missing required dependencies from database.");
                ExceptionUtils.logAndShowError((String)t.getMessage(), (Throwable)t);
            } else {
                cp.setErrorMessage("An unknown problem occurred while importing Sysdyn model.\n\nMessage: " + e.getMessage());
            }
            return false;
        }
        catch (InterruptedException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
            return false;
        }
        return true;
    }

    private void readPreferences(IStructuredSelection selection) {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.sysdyn.ui");
        String recentPathsPref = store.getString("RECENT_MODEL_IMPORT_LOCATIONS");
        Deque<String> recentImportPaths = Preferences.decodePaths(recentPathsPref);
        ISessionContext ctx = Simantics.getSessionContext();
        if (ctx == null) {
            return;
        }
        this.importModel = new SysdynImportModel(recentImportPaths);
        this.importModel.setSelection(selection.getFirstElement());
    }

    private void writePreferences() throws IOException {
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.sysdyn.ui");
        store.putValue("RECENT_MODEL_IMPORT_LOCATIONS", Preferences.encodePaths(this.importModel.getRecentLocations()));
        if (store.needsSaving()) {
            store.save();
        }
    }
}

