/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.utils;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.simantics.sysdyn.expressionParser.Token;

public class SyntaxError {
    private String type;
    private String message;
    private String image;
    private int beginLine;
    private int beginColumn;
    private int endLine;
    private int endColumn;
    private Integer start;
    private Integer offset;

    public SyntaxError() {
    }

    public SyntaxError(Token token, String message) {
        this(token.image, message, token.beginLine, token.beginColumn, token.endLine, token.endColumn);
    }

    public SyntaxError(org.simantics.sysdyn.tableParser.Token token, String message) {
        this(token.image, message, token.beginLine, token.beginColumn, token.endLine, token.endColumn);
    }

    public SyntaxError(String image, String message, int beginLine, int beginColumn, int endLine, int endColumn) {
        this.image = image;
        this.message = message;
        this.beginLine = beginLine;
        this.beginColumn = beginColumn;
        this.endLine = endLine;
        this.endColumn = endColumn;
        this.type = "SyntaxError";
    }

    public SyntaxError(int start, int offset, String type, String message) {
        this(start, offset, type, message, null);
    }

    public SyntaxError(int start, int offset, String type, String message, String image) {
        this.image = image;
        this.start = start;
        this.offset = offset;
        this.type = type;
        this.message = message;
    }

    public int getStart(IDocument document) {
        if (this.start != null) {
            return this.start;
        }
        if (document != null) {
            int start = 0;
            if (document.getLength() > 0) {
                try {
                    start = document.getLineOffset(this.beginLine - 1) + this.beginColumn - 1;
                }
                catch (BadLocationException badLocationException) {}
            }
            return start;
        }
        return 0;
    }

    public int getOffset(IDocument document) {
        if (this.offset != null) {
            return this.offset;
        }
        if (document != null) {
            int start = this.getStart(document);
            int offset = document.getLength();
            if (document.getLength() > 0) {
                try {
                    offset = document.getLineOffset(this.endLine - 1) + this.endColumn - start;
                }
                catch (BadLocationException badLocationException) {}
            }
            return offset;
        }
        return 0;
    }

    public void setToken(Token token) {
        this.image = token.image;
        this.beginLine = token.beginLine;
        this.beginColumn = token.beginColumn;
        this.endLine = token.endLine;
        this.endColumn = token.endColumn;
    }

    public void setToken(org.simantics.sysdyn.tableParser.Token token) {
        this.image = token.image;
        this.beginLine = token.beginLine;
        this.beginColumn = token.beginColumn;
        this.endLine = token.endLine;
        this.endColumn = token.endColumn;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getImage() {
        return this.image;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public int getBeginLine() {
        return this.beginLine;
    }

    public void setBeginLine(int beginLine) {
        this.beginLine = beginLine;
    }

    public int getBeginColumn() {
        return this.beginColumn;
    }

    public void setBeginColumn(int beginColumn) {
        this.beginColumn = beginColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }
}

