/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.modules;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.ui.properties.widgets.modules.ModuleParameterOverrideUtils;
import org.simantics.sysdyn.ui.properties.widgets.modules.ParameterNode;

public class ParameterLabelDecorationRule
implements LabelDecorationRule {
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Object.class);
    }

    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        if (content instanceof ParameterNode) {
            ParameterNode node = (ParameterNode)content;
            String notOverriding = ModuleParameterOverrideUtils.getParameterExpression(node.getIndependentVariable());
            String overriding = ModuleParameterOverrideUtils.getParameterExpressionOrOverride(graph, node.getParent(), node.getIndependentVariable());
            if (notOverriding == null) {
                return null;
            }
            final boolean original = notOverriding.equals(overriding);
            return new LabelDecorator.Stub(){

                public String decorateLabel(String label, String column, int itemIndex) {
                    if ("Value".equals(column)) {
                        return original ? label : String.valueOf(label) + " [Overridden]";
                    }
                    return label;
                }

                public <Color> Color decorateForeground(Color color, String column, int itemIndex) {
                    ColorDescriptor result = null;
                    if ("Value".equals(column)) {
                        result = original ? ColorDescriptor.createFrom((RGB)new RGB(125, 125, 125)) : ColorDescriptor.createFrom((RGB)new RGB(0, 0, 0));
                    }
                    return (Color)result;
                }
            };
        }
        return null;
    }
}

