/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.modules;

import java.util.Collection;
import java.util.List;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.representation.IndependentVariable;
import org.simantics.sysdyn.representation.expressions.IExpression;

public class ModuleParameterOverrideUtils {
    public static String getParameterExpression(IndependentVariable variable) throws DatabaseException {
        String result = null;
        try {
            result = ((IExpression)variable.getExpressions().get(0)).getExpression();
            if (result.contains("/* Actual value read from init file */")) {
                result = result.substring(0, result.indexOf("/* Actual value read from init file */"));
            }
        }
        catch (NullPointerException nullPointerException) {}
        return result;
    }

    public static String getParameterExpressionOrOverride(ReadGraph graph, Resource parent, IndependentVariable variable) throws DatabaseException {
        String result = null;
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        for (Resource r : (Collection)graph.syncRequest((Read)new ObjectsWithType(parent, L0.ConsistsOf, sr.Module_ParameterOverride))) {
            Resource overridden = graph.getPossibleObject(r, sr.Module_ParameterOverride_overriddenParameter);
            if (!variable.getName().equals(NameUtils.getSafeName((ReadGraph)graph, (Resource)overridden))) continue;
            result = (String)graph.getPossibleRelatedValue(r, sr.Module_ParameterOverride_overrideExpression);
        }
        if (result == null) {
            result = ModuleParameterOverrideUtils.getParameterExpression(variable);
        }
        return result;
    }

    public static boolean hasParameterExpression(ReadGraph graph, Resource variable) throws DatabaseException {
        List expressions;
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        boolean result = false;
        Resource expressionsResource = graph.getPossibleObject(variable, sr.Variable_expressionList);
        if (expressionsResource != null && (expressions = ListUtils.toList((ReadGraph)graph, (Resource)expressionsResource)).size() == 1 && graph.isInstanceOf((Resource)expressions.get(0), sr.ParameterExpression)) {
            result = true;
        }
        return result;
    }
}

