/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.functions;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.browsing.ui.graph.contributor.viewpoint.ViewpointContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.browser.nodes.SharedFunctionLibraryNode;

public class SharedFunctionLibraries
extends ViewpointContributor<Resource> {
    public Collection<?> getContribution(ReadGraph graph, Resource input) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        ArrayList<SharedFunctionLibraryNode> result = new ArrayList<SharedFunctionLibraryNode>();
        Resource sharedOntologies = null;
        Resource root = input;
        while (graph.getPossibleObject(root, l0.PartOf) != null) {
            root = graph.getPossibleObject(root, l0.PartOf);
        }
        for (Resource r : graph.getObjects(root, l0.ConsistsOf)) {
            if (!"SharedOntologies".equals(NameUtils.getSafeName((ReadGraph)graph, (Resource)r))) continue;
            sharedOntologies = r;
            break;
        }
        if (sharedOntologies == null) {
            return result;
        }
        ArrayList<Resource> sharedFunctionLibraries = new ArrayList<Resource>();
        for (Resource r : graph.getObjects(sharedOntologies, l0.ConsistsOf)) {
            if (!graph.isInstanceOf(r, sr.SharedFunctionOntology)) continue;
            sharedFunctionLibraries.add(r);
        }
        Collection selectedSharedFunctionLibraries = (Collection)graph.syncRequest((Read)new ObjectsWithType(input, l0.IsLinkedTo, sr.SharedFunctionOntology));
        sharedFunctionLibraries.removeAll(selectedSharedFunctionLibraries);
        for (Resource ontology : sharedFunctionLibraries) {
            result.add(new SharedFunctionLibraryNode(ontology));
        }
        return result;
    }
}

