/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.expressions;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class LookupInputOutputTable
extends Composite {
    public static final String INPUT = "Input";
    public static final String OUTPUT = "Output";
    public static final String[] PROPS = new String[]{"Input", "Output"};
    private Table table;
    private TableViewer tableViewer;
    private List<InputOutput> tableRows;

    public LookupInputOutputTable(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.fillDefaults().applyTo((Composite)this);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this);
        this.table = new Table((Composite)this, 67588);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.table);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.table.getVerticalBar().setVisible(true);
        TableColumn column1 = new TableColumn(this.table, 16384);
        column1.setText(INPUT);
        column1.setWidth(85);
        TableColumn column2 = new TableColumn(this.table, 16384);
        column2.setText(OUTPUT);
        column2.setWidth(85);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new InputOutputLabelProvider());
        this.tableViewer.setCellModifier((ICellModifier)new InputOutputCellModifier());
        this.tableRows = new ArrayList<InputOutput>();
        this.tableViewer.setInput(this.tableRows);
        CellEditor[] editors = new CellEditor[]{new TextCellEditor((Composite)this.table), new TextCellEditor((Composite)this.table)};
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setColumnProperties(PROPS);
    }

    public void addLocation(Point2D location) {
        this.tableRows.add(new InputOutput(location.getX(), location.getY()));
        this.tableViewer.getTable().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                LookupInputOutputTable.this.refresh();
            }
        });
    }

    public void removeItem(int index) {
        this.tableRows.remove(index);
        this.tableViewer.getTable().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                LookupInputOutputTable.this.refresh();
            }
        });
    }

    public void clearTable() {
        this.tableRows.clear();
        this.tableViewer.getTable().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                LookupInputOutputTable.this.refresh();
            }
        });
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void refresh() {
        if (!this.tableViewer.getTable().isDisposed()) {
            this.tableViewer.setComparator((ViewerComparator)new InputOutputComparator());
            this.tableViewer.refresh();
        }
    }

    private void tableModified() {
        this.tableViewer.getTable().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Listener[] listenerArray = LookupInputOutputTable.this.getListeners(24);
                int n = listenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Listener listener = listenerArray[n2];
                    Event e = new Event();
                    listener.handleEvent(e);
                    ++n2;
                }
            }
        });
    }

    public class InputOutput {
        private double input;
        private double output;

        public InputOutput(double input, double output) {
            this.input = input;
            this.output = output;
        }

        public Object getInput(Class clazz) {
            if (clazz == String.class) {
                return "" + this.input;
            }
            if (clazz == Double.class) {
                return this.input;
            }
            return null;
        }

        public Double setInput(String input) {
            try {
                this.input = Double.parseDouble(input);
                return this.input;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        public void setInput(double input) {
            this.input = input;
        }

        public Object getOutput(Class clazz) {
            if (clazz == String.class) {
                return "" + this.output;
            }
            if (clazz == Double.class) {
                return this.output;
            }
            return null;
        }

        public void setOutput(String output) {
            try {
                this.output = Double.parseDouble(output);
            }
            catch (NumberFormatException numberFormatException) {}
        }

        public void setOutput(double output) {
            this.output = output;
        }
    }

    class InputOutputCellModifier
    implements ICellModifier {
        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            InputOutput io = (InputOutput)element;
            if (LookupInputOutputTable.INPUT.equals(property)) {
                return (String)io.getInput(String.class);
            }
            if (LookupInputOutputTable.OUTPUT.equals(property)) {
                return (String)io.getOutput(String.class);
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            InputOutput io = (InputOutput)element;
            if (LookupInputOutputTable.INPUT.equals(property)) {
                io.setInput((String)value);
            } else if (LookupInputOutputTable.OUTPUT.equals(property)) {
                io.setOutput((String)value);
            }
            LookupInputOutputTable.this.tableModified();
            LookupInputOutputTable.this.refresh();
        }
    }

    public class InputOutputComparator
    extends ViewerComparator
    implements Comparator<InputOutput> {
        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof InputOutput && e2 instanceof InputOutput) {
                return this.compare((InputOutput)e1, (InputOutput)e2);
            }
            return 0;
        }

        @Override
        public int compare(InputOutput e1, InputOutput e2) {
            InputOutput io1 = e1;
            InputOutput io2 = e2;
            Double d1 = (Double)io1.getInput(Double.class);
            Double d2 = (Double)io2.getInput(Double.class);
            return d1.compareTo(d2);
        }
    }

    private class InputOutputLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private InputOutputLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof InputOutput) {
                InputOutput io = (InputOutput)element;
                switch (columnIndex) {
                    case 0: {
                        return (String)io.getInput(String.class);
                    }
                    case 1: {
                        return (String)io.getOutput(String.class);
                    }
                }
            }
            return "";
        }
    }
}

