/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties.widgets.expressions;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.properties.widgets.ShortcutTabWidget;
import org.simantics.sysdyn.ui.properties.widgets.expressions.ExpressionWidgetInput;
import org.simantics.sysdyn.ui.utils.ExpressionUtils;
import org.simantics.sysdyn.utils.Function;
import org.simantics.ui.SimanticsUI;

public class CompletionProcessor
implements IContentAssistProcessor {
    private final Table allowedVariables;
    private ArrayList<Function> functions;
    private ArrayList<String> variables = null;
    private ArrayList<String> timeAndSelfVariables = null;
    private final ExpressionWidgetInput input;
    private LocalResourceManager resourceManager;
    private static final char[] ALLOWED_CHARACTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '\ufffd', '\ufffd', '\ufffd', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\ufffd', '\ufffd', '\ufffd', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '.', '(', ')'};
    private static final String ALLOWED_CONNECTED_CHARACTERS_REG_EXP = "[\\Q({[:;,<=>+-*/^\\E]";
    private static final ArrayList<String> ALLOW_ALL_COMPLETIONS_LIST = new ArrayList();

    static {
        ALLOW_ALL_COMPLETIONS_LIST.add("");
    }

    public CompletionProcessor(Table allowedVariables, boolean allowFunctions, ExpressionWidgetInput input) {
        this.allowedVariables = allowedVariables;
        this.input = input;
        this.functions = new ArrayList();
        if (allowFunctions) {
            if (input != null && this.input.variable != null) {
                Resource model = null;
                try {
                    model = (Resource)SimanticsUI.getSession().syncRequest((Read)new Read<Resource>(){

                        public Resource perform(ReadGraph graph) throws DatabaseException {
                            return Variables.getModel((ReadGraph)graph, (Variable)((CompletionProcessor)CompletionProcessor.this).input.variable);
                        }
                    });
                    this.functions.addAll(Function.getUserDefinedFunctions((Resource)model));
                    this.functions.addAll(Function.getSharedFunctions((Resource)model));
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            }
            this.functions.addAll(Function.getAllBuiltInFunctions());
            Collections.sort(this.functions);
        }
    }

    private void findVariables() {
        if (this.variables == null) {
            this.variables = new ArrayList();
            this.timeAndSelfVariables = new ArrayList();
            if (this.allowedVariables != null && !this.allowedVariables.isDisposed()) {
                TableItem[] connectedVariables;
                TableItem[] tableItemArray = connectedVariables = this.allowedVariables.getItems();
                int n = connectedVariables.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem ti = tableItemArray[n2];
                    if (ExpressionUtils.variableTimeAndSelfColor(this.resourceManager).equals((Object)ti.getForeground())) {
                        this.timeAndSelfVariables.add(ti.getText());
                    } else {
                        this.variables.add(ti.getText());
                    }
                    ++n2;
                }
            }
            Collections.sort(this.variables);
            Collections.sort(this.timeAndSelfVariables);
        }
    }

    private void addVariables(ArrayList<ICompletionProposal> array, String token, int offset) {
        Image imageVariable = this.resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/variable.png")));
        Image imageVariableGray = this.resourceManager.createImage(ImageDescriptor.createFromURL((URL)Activator.getDefault().getBundle().getResource("icons/variableGray.png")));
        for (String variable : this.variables) {
            if (token.length() != 0 && !variable.toUpperCase().startsWith(token.toUpperCase()) || this.listContainsVariable(array, variable)) continue;
            array.add((ICompletionProposal)new CompletionProposal(variable, offset - token.length(), token.length(), variable.length(), imageVariable, variable, null, null));
        }
        for (String variable : this.timeAndSelfVariables) {
            if (token.length() != 0 && !variable.toUpperCase().startsWith(token.toUpperCase()) || this.listContainsVariable(array, variable)) continue;
            array.add((ICompletionProposal)new CompletionProposal(variable, offset - token.length(), token.length(), variable.length(), imageVariableGray, variable, null, null));
        }
    }

    private boolean listContainsVariable(ArrayList<ICompletionProposal> array, String variable) {
        for (ICompletionProposal proposal : array) {
            if (!proposal.getDisplayString().equals(variable)) continue;
            return true;
        }
        return false;
    }

    private void addFunctions(ArrayList<ICompletionProposal> array, String token, int offset) {
        if (this.functions == null) {
            return;
        }
        for (Function function : this.functions) {
            if (token.length() != 0 && !function.getName().toUpperCase().startsWith(token.toUpperCase())) continue;
            Image image = ShortcutTabWidget.getImage(this.resourceManager, function);
            String parameterList = Function.inputListToString((ArrayList)function.getInputList());
            array.add((ICompletionProposal)new CompletionProposal(String.valueOf(function.getName()) + "(" + parameterList + ")", offset - token.length(), token.length(), function.getName().length() + 1, image, String.valueOf(function.getName()) + "(" + parameterList + ")", null, function.getDescriptionHTML()));
        }
    }

    private ICompletionProposal[] collectProposals(ArrayList<String> possibleLabelBeginnings, int offset) {
        ArrayList<ICompletionProposal> resultArray = new ArrayList<ICompletionProposal>();
        this.findVariables();
        Collections.sort(possibleLabelBeginnings, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1.length() > o2.length()) {
                    return -1;
                }
                if (o1.length() < o2.length()) {
                    return 1;
                }
                return 0;
            }
        });
        for (String possibleLabelBeginning : possibleLabelBeginnings) {
            this.addVariables(resultArray, possibleLabelBeginning, offset);
        }
        this.addFunctions(resultArray, possibleLabelBeginnings.get(possibleLabelBeginnings.size() - 1), offset);
        ICompletionProposal[] result = new ICompletionProposal[resultArray.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = resultArray.get(i);
            ++i;
        }
        return result;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String equation = viewer.getDocument().get();
        StyledText control = viewer.getTextWidget();
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)control);
        if (equation.length() == 0 || offset == 0) {
            return this.collectProposals(ALLOW_ALL_COMPLETIONS_LIST, offset);
        }
        String[] stringsBetweenConnectedCharacters = (equation = equation.substring(0, offset)).split(ALLOWED_CONNECTED_CHARACTERS_REG_EXP);
        if (stringsBetweenConnectedCharacters.length == 0) {
            return this.collectProposals(ALLOW_ALL_COMPLETIONS_LIST, offset);
        }
        String stringAfterLastConnectedCharacter = stringsBetweenConnectedCharacters[stringsBetweenConnectedCharacters.length - 1];
        String stringAfterWhitespaceAfterLastConnectedCharacter = this.removeLeadingWhitespace(stringAfterLastConnectedCharacter);
        String[] tokens = stringAfterWhitespaceAfterLastConnectedCharacter.split("[\\s]", -42);
        if (this.allTokensAreEmpty(tokens)) {
            return this.collectProposals(ALLOW_ALL_COMPLETIONS_LIST, offset);
        }
        return this.collectProposals(this.getPossibleLabelBeginnings(tokens), offset);
    }

    private ArrayList<String> getPossibleLabelBeginnings(String[] tokens) {
        ArrayList<String> possibleLabelBeginnings = new ArrayList<String>();
        int i = 0;
        while (i < tokens.length) {
            String token = new String();
            int j = i;
            while (j < tokens.length) {
                token = String.valueOf(token) + " " + tokens[j];
                ++j;
            }
            token = token.substring(1);
            possibleLabelBeginnings.add(token);
            ++i;
        }
        return possibleLabelBeginnings;
    }

    private String removeLeadingWhitespace(String input) {
        int i = 0;
        while (i < input.length()) {
            if (!Character.isWhitespace(input.charAt(i))) {
                return input.substring(i);
            }
            ++i;
        }
        return "";
    }

    private boolean allTokensAreEmpty(String[] tokens) {
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            if (!token.equals("")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return ALLOWED_CHARACTERS;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return "Error in CompletionProcessor";
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }
}

