/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.nodetypes.SpecialNodeType;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.request.PossibleActiveVariableFromVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.jfreechart.ChartSelectionTabContributor;
import org.simantics.jfreechart.chart.properties.ChartTab;
import org.simantics.jfreechart.chart.properties.xyline.XYLineGeneralPropertiesTab;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.property.svg.SVGElementComposite;
import org.simantics.selectionview.ComparableTabContributor;
import org.simantics.selectionview.PropertyTabContributor;
import org.simantics.selectionview.SelectionProcessor;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.browser.nodes.SharedFunctionsFolder;
import org.simantics.sysdyn.ui.properties.ArrayDependencyTab;
import org.simantics.sysdyn.ui.properties.ArrayFlowTab;
import org.simantics.sysdyn.ui.properties.ArrayIndexesTab;
import org.simantics.sysdyn.ui.properties.CommentTab;
import org.simantics.sysdyn.ui.properties.ConfigurationTab;
import org.simantics.sysdyn.ui.properties.DependencyTab;
import org.simantics.sysdyn.ui.properties.EnumerationTab;
import org.simantics.sysdyn.ui.properties.EquationTab;
import org.simantics.sysdyn.ui.properties.ExperimentTab;
import org.simantics.sysdyn.ui.properties.ExternalFilesTab;
import org.simantics.sysdyn.ui.properties.FlowTab;
import org.simantics.sysdyn.ui.properties.FunctionLibraryTab;
import org.simantics.sysdyn.ui.properties.FunctionTab;
import org.simantics.sysdyn.ui.properties.GameExperimentTab;
import org.simantics.sysdyn.ui.properties.HistoryDataTab;
import org.simantics.sysdyn.ui.properties.InputVariableTab;
import org.simantics.sysdyn.ui.properties.LookupTableTab;
import org.simantics.sysdyn.ui.properties.LoopTab;
import org.simantics.sysdyn.ui.properties.ModuleInputTab;
import org.simantics.sysdyn.ui.properties.ModuleOutputTab;
import org.simantics.sysdyn.ui.properties.ModuleParameterTab;
import org.simantics.sysdyn.ui.properties.ModuleTab;
import org.simantics.sysdyn.ui.properties.ModuleTypeTab;
import org.simantics.sysdyn.ui.properties.PlaybackExperimentTab;
import org.simantics.sysdyn.ui.properties.ResultTab;
import org.simantics.sysdyn.ui.properties.SensitivityAnalysisExperimentTab;
import org.simantics.sysdyn.ui.properties.SharedFunctionLibrariesTab;
import org.simantics.sysdyn.ui.properties.VariableInformationTab;
import org.simantics.sysdyn.ui.trend.SensitivityChartAxisAndVariablesTab;
import org.simantics.sysdyn.utils.SelectionUtils;
import org.simantics.ui.selection.AnyVariable;
import org.simantics.ui.selection.WorkbenchSelectionContentType;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ISelectionUtils;

public class ResourceSelectionProcessor
implements SelectionProcessor<Object, ReadGraph> {
    private SpecialNodeType sharedFunctionsTestNode;

    public Collection<?> process(Object selection, ReadGraph backend) {
        ArrayList<ComparableTabContributor> tabs = new ArrayList<ComparableTabContributor>();
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)backend);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)backend);
        ModelingResources mr = ModelingResources.getInstance((ReadGraph)backend);
        SimulationResource simu = SimulationResource.getInstance((ReadGraph)backend);
        if (this.sharedFunctionsTestNode == null) {
            this.sharedFunctionsTestNode = new SpecialNodeType(sr.ModelingBrowseContext_SharedFunctionsFolder, Resource.class);
        }
        try {
            Resource diaConnection;
            Object s;
            Resource original;
            NodeType type;
            Resource r;
            Variable possibleActiveVariable;
            if (selection instanceof ArrayList && ((ArrayList)selection).size() > 1) {
                ArrayList<Resource> variables = new ArrayList<Resource>();
                ArrayList<Resource> dependencies = new ArrayList<Resource>();
                ArrayList<Resource> flows = new ArrayList<Resource>();
                Resource model = null;
                for (Object o : (ArrayList)selection) {
                    Resource diaConnection2;
                    Resource r2 = (Resource)AdaptionUtils.adaptToSingle(o, Resource.class);
                    if (r2 == null) continue;
                    Resource component = backend.getPossibleObject(r2, mr.ElementToComponent);
                    if (component != null) {
                        r2 = component;
                    } else {
                        Resource connection = backend.getPossibleObject(r2, mr.DiagramConnectionToConnection);
                        if (connection != null) {
                            r2 = connection;
                        }
                    }
                    if (r2 == null) continue;
                    if (model == null) {
                        model = backend.getPossibleObject(r2, Layer0.getInstance((ReadGraph)backend).PartOf);
                    }
                    if (model == null || !model.equals(backend.getSingleObject(r2, Layer0.getInstance((ReadGraph)backend).PartOf))) continue;
                    if (backend.isInstanceOf(r2, sr.Variable)) {
                        variables.add(r2);
                        continue;
                    }
                    if (backend.isInstanceOf(r2, sr.Dependency)) {
                        diaConnection2 = backend.getPossibleObject(r2, ModelingResources.getInstance((ReadGraph)backend).ConnectionToDiagramConnection);
                        dependencies.add(diaConnection2);
                        continue;
                    }
                    if (!backend.isInstanceOf(r2, sr.Flow)) continue;
                    diaConnection2 = backend.getPossibleObject(r2, ModelingResources.getInstance((ReadGraph)backend).ConnectionToDiagramConnection);
                    flows.add(diaConnection2);
                }
                if (!variables.isEmpty()) {
                    tabs.add(new ComparableTabContributor((PropertyTabContributor)new ArrayIndexesTab(variables), 1.0, variables, "Indexes"));
                } else if (!dependencies.isEmpty()) {
                    tabs.add(new ComparableTabContributor((PropertyTabContributor)new ArrayDependencyTab(dependencies), 1.0, dependencies, "Dependency Properties"));
                } else if (!flows.isEmpty()) {
                    tabs.add(new ComparableTabContributor((PropertyTabContributor)new ArrayFlowTab(flows), 1.0, flows, "Flow Properties"));
                }
                return tabs;
            }
            Variable var = null;
            WorkbenchSelectionElement wse = (WorkbenchSelectionElement)ISelectionUtils.filterSingleSelection((Object)selection, WorkbenchSelectionElement.class);
            if (wse != null && (var = (Variable)wse.getContent((WorkbenchSelectionContentType)new AnyVariable((RequestProcessor)backend))) == null && (var = (Variable)AdaptionUtils.adaptToSingle((Object)selection, Variable.class)) != null && (possibleActiveVariable = (Variable)backend.syncRequest((Read)new PossibleActiveVariableFromVariable(var))) != null) {
                var = possibleActiveVariable;
            }
            if ((r = (Resource)AdaptionUtils.adaptToSingle((Object)selection, Resource.class)) == null && (var = (Variable)AdaptionUtils.adaptToSingle((Object)selection, Variable.class)) != null) {
                r = var.getRepresents(backend);
            }
            if (r == null) {
                SharedFunctionsFolder sff = (SharedFunctionsFolder)((Object)AdaptionUtils.adaptToSingle((Object)selection, SharedFunctionsFolder.class));
                if (sff != null) {
                    return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new SharedFunctionLibrariesTab(sff.data), 2.0, sff.data, "Shared Functions"));
                }
                return Collections.emptyList();
            }
            NodeContext nc = (NodeContext)AdaptionUtils.adaptToSingle((Object)selection, NodeContext.class);
            if (nc != null && (type = (NodeType)nc.getConstant(NodeType.TYPE)) != null && type.equals(this.sharedFunctionsTestNode)) {
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new SharedFunctionLibrariesTab(r), 2.0, (Object)r, "Shared Functions"));
            }
            if (backend.isInstanceOf(r, dr.SVGElement)) {
                return Collections.singleton(SVGElementComposite.make((Resource)r, (double)1.0, (String)"SVG"));
            }
            if (backend.isInstanceOf(r, dr.Element)) {
                Resource component = backend.getPossibleObject(r, mr.ElementToComponent);
                if (component != null) {
                    r = component;
                } else {
                    Resource connection = backend.getPossibleObject(r, mr.DiagramConnectionToConnection);
                    if (connection != null) {
                        r = connection;
                    }
                }
            }
            if (r != null && var != null && !r.equals(var.getRepresents(backend))) {
                var = null;
            }
            if (backend.isInstanceOf(r, sr.Shadow) && (original = backend.getPossibleObject(r, sr.Shadow_original)) != null && var != null) {
                r = original;
                Variable parent = var.getParent(backend);
                var = parent.getPossibleChild(backend, NameUtils.getSafeName((ReadGraph)backend, (Resource)r));
            }
            if (backend.isInstanceOf(r, sr.Loop)) {
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new LoopTab(r), 1.0, (Object)r, "Loop"));
            }
            if (backend.isInstanceOf(r, sr.IndependentVariable)) {
                Resource activeExpression = backend.getPossibleObject(r, sr.IndependentVariable_activeExpression);
                Resource expression = null;
                if (activeExpression != null) {
                    expression = activeExpression;
                } else if (backend.hasStatement(r, sr.Variable_expressionList)) {
                    Resource expressions = backend.getPossibleObject(r, sr.Variable_expressionList);
                    List expressionList = ListUtils.toList((ReadGraph)backend, (Resource)expressions);
                    if (expressionList.isEmpty()) {
                        System.err.println("expressionList is empty for " + r);
                        return Collections.emptyList();
                    }
                    expression = (Resource)expressionList.get(0);
                }
                tabs.add(new ComparableTabContributor((PropertyTabContributor)new EquationTab(var != null ? var : r), 3.0, var != null ? var : r, "Equation"));
                if (expression != null && backend.isInstanceOf(expression, sr.WithLookupExpression)) {
                    tabs.add(new ComparableTabContributor((PropertyTabContributor)new LookupTableTab(expression), 2.0, (Object)expression, "Lookup Table"));
                }
                tabs.add(new ComparableTabContributor((PropertyTabContributor)new ArrayIndexesTab(r), 1.0, (Object)r, "Indexes"));
                tabs.add(new ComparableTabContributor((PropertyTabContributor)new VariableInformationTab(r), 0.0, (Object)r, "Additional Information"));
                return tabs;
            }
            if (backend.isInstanceOf(r, sr.Input)) {
                tabs.add(new ComparableTabContributor((PropertyTabContributor)new InputVariableTab(r), 2.0, (Object)r, "Input"));
                tabs.add(new ComparableTabContributor((PropertyTabContributor)new ArrayIndexesTab(r), 1.0, (Object)r, "Indexes"));
                tabs.add(new ComparableTabContributor((PropertyTabContributor)new VariableInformationTab(r), 0.0, (Object)r, "Additional Information"));
                return tabs;
            }
            if (backend.isInstanceOf(r, sr.Enumeration)) {
                s = AdaptionUtils.adaptToSingle((Object)selection, ISelection.class);
                if (s == null) {
                    s = r;
                }
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new EnumerationTab(s), 2.0, s, "Enumeration"));
            }
            if (backend.isInstanceOf(r, sr.Configuration) || backend.isInstanceOf(r, sr.SysdynModel)) {
                if (!backend.isInstanceOf(r, sr.SysdynModel)) {
                    r = backend.getPossibleObject(r, SimulationResource.getInstance((ReadGraph)backend).IsConfigurationOf);
                }
                if (r != null) {
                    return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new ConfigurationTab(r), 0.0, (Object)r, "Model Properties"));
                }
            }
            if (backend.isInstanceOf(r, sr.Module)) {
                tabs.add(new ComparableTabContributor((PropertyTabContributor)new ModuleTab(r), 10.0, (Object)r, "Module Properties"));
                tabs.add(new ComparableTabContributor((PropertyTabContributor)new ModuleParameterTab(r), 9.0, (Object)r, "Parameters"));
                tabs.add(new ComparableTabContributor((PropertyTabContributor)new ModuleInputTab(r), 2.0, (Object)r, "Inputs"));
                tabs.add(new ComparableTabContributor((PropertyTabContributor)new ModuleOutputTab(r), 1.0, (Object)r, "Outputs"));
                return tabs;
            }
            if (backend.isInstanceOf(r, sr.PlaybackExperiment)) {
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new PlaybackExperimentTab(r), 0.0, (Object)r, "Experiment Properties"));
            }
            if (backend.isInstanceOf(r, sr.GameExperiment)) {
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new GameExperimentTab(r), 0.0, (Object)r, "Experiment Properties"));
            }
            if (backend.isInstanceOf(r, sr.SensitivityAnalysisExperiment)) {
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new SensitivityAnalysisExperimentTab(r), 0.0, (Object)r, "Experiment Properties"));
            }
            if (backend.isInstanceOf(r, simu.Experiment)) {
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new ExperimentTab(r), 0.0, (Object)r, "Experiment Properties"));
            }
            if (backend.isInstanceOf(r, sr.HistoryDataset)) {
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new HistoryDataTab(r), 0.0, (Object)r, "History Data Properties"));
            }
            if (backend.isInstanceOf(r, sr.Result)) {
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new ResultTab(r), 0.0, (Object)r, "Result Properties"));
            }
            if (backend.isInstanceOf(r, sr.Dependency)) {
                if (backend.hasStatement(r, sr.Dependency_refersTo)) {
                    diaConnection = backend.getPossibleObject(r, ModelingResources.getInstance((ReadGraph)backend).ConnectionToDiagramConnection);
                    return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new DependencyTab(diaConnection), 0.0, (Object)diaConnection, "Reference Properties"));
                }
                diaConnection = backend.getPossibleObject(r, ModelingResources.getInstance((ReadGraph)backend).ConnectionToDiagramConnection);
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new DependencyTab(diaConnection), 0.0, (Object)diaConnection, "Dependency Properties"));
            }
            if (backend.isInstanceOf(r, sr.Flow)) {
                diaConnection = backend.getPossibleObject(r, ModelingResources.getInstance((ReadGraph)backend).ConnectionToDiagramConnection);
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new FlowTab(diaConnection), 0.0, (Object)diaConnection, "Flow Properties"));
            }
            if (backend.isInheritedFrom(r, sr.ModuleSymbol) && (r = backend.getPossibleObject(r, mr.SymbolToComponentType)) != null) {
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new ModuleTypeTab(r), 0.0, (Object)r, "Module Type Properties"));
            }
            if (backend.isInstanceOf(r, sr.SysdynModelicaFunction)) {
                tabs.add(new ComparableTabContributor((PropertyTabContributor)new FunctionTab(r), 2.0, (Object)r, "Function"));
                if (SelectionUtils.canEdit((ReadGraph)backend, (Resource)r)) {
                    tabs.add(new ComparableTabContributor((PropertyTabContributor)new ExternalFilesTab(r), 1.0, (Object)r, "External files"));
                }
                return tabs;
            }
            if (backend.isInstanceOf(r, sr.SysdynModelicaFunctionLibrary)) {
                s = AdaptionUtils.adaptToSingle((Object)selection, ISelection.class);
                if (s == null) {
                    s = r;
                }
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new FunctionLibraryTab(s), 2.0, s, "Function library"));
            }
            if (ResourceSelectionProcessor.contributeSensitivityChart(backend, r, tabs)) {
                return tabs;
            }
            if (ChartSelectionTabContributor.contibuteTabs((ReadGraph)backend, (Resource)r, tabs)) {
                return tabs;
            }
            if (backend.isInstanceOf(r, sr.AdditionalSymbols_MultilineText)) {
                return Collections.singleton(new ComparableTabContributor((PropertyTabContributor)new CommentTab(r), 0.0, (Object)r, "Comment"));
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        catch (ManyObjectsForFunctionalRelationException e) {
            e.printStackTrace();
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    public static boolean contributeSensitivityChart(ReadGraph backend, Resource r, List<ComparableTabContributor> tabs) throws DatabaseException {
        Resource plot;
        Collection plots;
        JFreeChartResource jfree = JFreeChartResource.getInstance((ReadGraph)backend);
        if (backend.isInstanceOf(r, jfree.ChartElement) && backend.hasStatement(r, jfree.ChartElement_component)) {
            r = backend.getSingleObject(r, jfree.ChartElement_component);
        }
        if (backend.isInstanceOf(r, jfree.Chart) && !(plots = (Collection)backend.syncRequest((Read)new ObjectsWithType(r, Layer0.getInstance((ReadGraph)backend).ConsistsOf, jfree.Plot))).isEmpty() && backend.isInstanceOf(plot = (Resource)plots.iterator().next(), SysdynResource.getInstance((ReadGraph)backend).Charts_SensitivityPlot)) {
            tabs.add(new ComparableTabContributor((PropertyTabContributor)new XYLineGeneralPropertiesTab((Object)r), 10.0, (Object)r, "General"));
            tabs.add(new ComparableTabContributor((PropertyTabContributor)new SensitivityChartAxisAndVariablesTab(r), 9.0, (Object)r, "Axis and Variables"));
            tabs.add(new ComparableTabContributor((PropertyTabContributor)new ChartTab((Object)r), 1.0, (Object)r, "Chart"));
            return true;
        }
        return false;
    }
}

