/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.properties;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.swt.SingleSelectionInputSource;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.GraphExplorerComposite;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.Table;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactory;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListener;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.jfreechart.chart.properties.LabelPropertyTabContributor;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.manager.SysdynModel;
import org.simantics.sysdyn.manager.SysdynModelManager;
import org.simantics.sysdyn.ui.properties.widgets.arrays.EnumerationIndexNode;
import org.simantics.sysdyn.ui.properties.widgets.arrays.ReplaceableIndexesWidget;
import org.simantics.sysdyn.ui.properties.widgets.factories.VariableNameInputValidator;
import org.simantics.sysdyn.ui.properties.widgets.factories.VariableNamePropertyModifier;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.threads.SWTThread;
import org.simantics.utils.ui.AdaptionUtils;

public class EnumerationTab
extends LabelPropertyTabContributor
implements Widget {
    GraphExplorerComposite indexExplorer;
    Button showAll;
    Variable variable;
    Table table;
    private Button add;
    private Button remove;
    private int currentItemCount = 0;
    private int lastItemCount = 0;

    public EnumerationTab(Object id) {
        super(id);
    }

    public void createControls(Composite body, IWorkbenchSite site, ISessionContext context, WidgetSupport support) {
        support.register((Widget)this);
        Composite container = new Composite(body, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(4).applyTo(container);
        TrackedText nameText = new TrackedText(container, support, 2048);
        nameText.setTextFactory((ReadFactory)new StringPropertyFactory("http://www.simantics.org/Layer0-1.1/HasName"));
        nameText.addModifyListener((TextModifyListener)new VariableNamePropertyModifier(context, "http://www.simantics.org/Layer0-1.1/HasName"));
        nameText.setInputValidator((IInputValidator)new VariableNameInputValidator(support));
        GridDataFactory.fillDefaults().grab(true, false).span(4, 1).applyTo((Control)nameText.getWidget());
        this.indexExplorer = new GraphExplorerComposite((Map)ArrayMap.keys((Object[])new String[]{"displaySelectors", "displayFilter"}).values(new Object[]{false, false}), site, container, support, 67618);
        this.indexExplorer.setContextMenuId("#EnumerationTabPopup");
        this.indexExplorer.setBrowseContexts(new String[]{"http://www.simantics.org/Sysdyn-1.1/EnumerationIndexes"});
        this.indexExplorer.setInputSource((GraphExplorerComposite.InputSource)new SingleSelectionInputSource(Resource.class));
        ((Tree)this.indexExplorer.getExplorerControl()).addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TreeItem item = (TreeItem)event.item;
                    boolean checked = item.getChecked();
                    NodeContext context = (NodeContext)item.getData();
                    EnumerationIndexNode node = (EnumerationIndexNode)((Object)context.getAdapter(EnumerationIndexNode.class));
                    node.setShowInChartsSelected(checked);
                    Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                        public void run(ReadGraph graph) throws DatabaseException {
                            EnumerationTab.this.updateModelResults(graph);
                        }
                    });
                }
            }
        });
        this.indexExplorer.finish();
        GridDataFactory.fillDefaults().grab(true, true).span(4, 1).applyTo((Control)this.indexExplorer);
        Control c = (Control)this.indexExplorer.getExplorerControl();
        if (c instanceof Tree) {
            ((Tree)c).setLinesVisible(true);
        }
        this.add = new Button(container, support, 0);
        this.add.setText("Add");
        this.add.addSelectionListener((SelectionListener)new AddEnumerationIndexListener(support));
        this.remove = new Button(container, support, 0);
        this.remove.setText("Remove");
        this.remove.addSelectionListener((SelectionListener)new RemoveEnumerationIndexListener(support));
        ReplaceableIndexesWidget externalIndexes = new ReplaceableIndexesWidget(container, support, 0);
        GridDataFactory.fillDefaults().applyTo((Control)externalIndexes.getWidget());
        this.showAll = new Button(container, support, 32);
        this.showAll.setText("Show all in charts");
        this.showAll.addSelectionListener((SelectionListener)new ShowAllIndexesListener(support));
    }

    private void updateModelResults(ReadGraph graph) {
        try {
            Resource modelResource;
            if (this.variable != null && (modelResource = Variables.getModel((ReadGraph)graph, (Variable)this.variable)) != null) {
                Resource configuration = graph.getSingleObject(modelResource, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration);
                SysdynModel model = SysdynModelManager.getInstance((Session)graph.getSession()).getModel(graph, configuration);
                model.resultChanged();
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    public void setInput(ISessionContext context, Object input) {
        this.variable = (Variable)AdaptionUtils.adaptToSingle((Object)input, Variable.class);
    }

    private void updateRemoveButton(final boolean enable) {
        SWTThread.getThreadAccess().asyncExec(new Runnable(){

            @Override
            public void run() {
                EnumerationTab.this.remove.getWidget().setEnabled(enable);
                if (!enable) {
                    EnumerationTab.this.add.getWidget().setFocus();
                }
            }
        });
    }

    private void enableItemForRename() {
        Job j = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                while (EnumerationTab.this.lastItemCount == EnumerationTab.this.currentItemCount) {
                    SWTThread.getThreadAccess().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            EnumerationTab.this.lastItemCount = EnumerationTab.this.getCurrentItemCount();
                        }
                    });
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                SWTThread.getThreadAccess().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Control c = (Control)(this).EnumerationTab.this.indexExplorer.getExplorer().getControl();
                        if (c instanceof Tree) {
                            Tree tree = (Tree)c;
                            TreeItem[] items = tree.getItems();
                            TreeItem lastItem = items[items.length - 1];
                            tree.setSelection(lastItem);
                        }
                    }
                });
                SWTThread.getThreadAccess().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Control c = (Control)(this).EnumerationTab.this.indexExplorer.getExplorer().getControl();
                        if (c instanceof Tree) {
                            Tree tree = (Tree)c;
                            TreeItem[] items = tree.getItems();
                            TreeItem lastItem = items[items.length - 1];
                            NodeContext context = (NodeContext)lastItem.getData();
                            tree.setSelection(lastItem);
                            (this).EnumerationTab.this.indexExplorer.getExplorer().startEditing(context, "single");
                            tree.setSelection(lastItem);
                        }
                    }
                });
                return Status.OK_STATUS;
            }
        };
        j.schedule();
    }

    public int getCurrentItemCount() {
        Control c = (Control)this.indexExplorer.getExplorer().getControl();
        Tree tree = (Tree)c;
        return tree.getItemCount();
    }

    private class AddEnumerationIndexListener
    implements SelectionListener,
    Widget {
        Resource enumerationIndexes;

        public AddEnumerationIndexListener(WidgetSupport support) {
            support.register((Widget)this);
        }

        public void setInput(ISessionContext context, Object input) {
            final Resource enumeration = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
            try {
                context.getSession().syncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        AddEnumerationIndexListener.this.enumerationIndexes = graph.getSingleObject(enumeration, SysdynResource.getInstance((ReadGraph)graph).Enumeration_enumerationIndexList);
                    }
                });
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            try {
                EnumerationTab.this.currentItemCount = EnumerationTab.this.getCurrentItemCount();
                EnumerationTab.this.lastItemCount = EnumerationTab.this.currentItemCount;
                Simantics.getSession().syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        HashSet<String> names = new HashSet<String>();
                        for (Resource r : ListUtils.toList((ReadGraph)graph, (Resource)AddEnumerationIndexListener.this.enumerationIndexes)) {
                            names.add(NameUtils.getSafeName((ReadGraph)graph, (Resource)r));
                        }
                        Resource ei = GraphUtils.create2((WriteGraph)graph, (Resource)sr.EnumerationIndex, (Object[])new Object[]{l0.HasName, NameUtils.findFreshName((ReadGraph)graph, (String)"index", names, (String)"")});
                        ArrayList<Resource> index = new ArrayList<Resource>();
                        index.add(ei);
                        ListUtils.insertBack((WriteGraph)graph, (Resource)AddEnumerationIndexListener.this.enumerationIndexes, index);
                        List list = ListUtils.toList((ReadGraph)graph, (Resource)AddEnumerationIndexListener.this.enumerationIndexes);
                        if (!list.isEmpty()) {
                            EnumerationTab.this.updateRemoveButton(true);
                        }
                        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Added new Enumeration Index " + NameUtils.getSafeName((ReadGraph)graph, (Resource)ei) + " to " + AddEnumerationIndexListener.this.enumerationIndexes));
                    }
                });
                EnumerationTab.this.enableItemForRename();
            }
            catch (DatabaseException e1) {
                e1.printStackTrace();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            System.out.println("asd");
        }
    }

    private class RemoveEnumerationIndexListener
    implements SelectionListener,
    Widget {
        Resource enumerationIndexes;

        public RemoveEnumerationIndexListener(WidgetSupport support) {
            support.register((Widget)this);
        }

        public void setInput(ISessionContext context, Object input) {
            final Resource enumeration = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
            try {
                context.getSession().syncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        RemoveEnumerationIndexListener.this.enumerationIndexes = graph.getSingleObject(enumeration, SysdynResource.getInstance((ReadGraph)graph).Enumeration_enumerationIndexList);
                        List list = ListUtils.toList((ReadGraph)graph, (Resource)RemoveEnumerationIndexListener.this.enumerationIndexes);
                        if (list.isEmpty()) {
                            EnumerationTab.this.updateRemoveButton(false);
                        }
                    }
                });
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }

        public void widgetSelected(SelectionEvent e) {
            ISelectionProvider selectionProvider = (ISelectionProvider)EnumerationTab.this.indexExplorer.getAdapter(ISelectionProvider.class);
            final IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
            try {
                Simantics.getSession().syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        for (Object o : selection.toList()) {
                            Resource r = (Resource)AdaptionUtils.adaptToSingle(o, Resource.class);
                            if (r == null) continue;
                            ListUtils.removeElement((WriteGraph)graph, (Resource)RemoveEnumerationIndexListener.this.enumerationIndexes, (Resource)r);
                        }
                        List list = ListUtils.toList((ReadGraph)graph, (Resource)RemoveEnumerationIndexListener.this.enumerationIndexes);
                        if (list.isEmpty()) {
                            EnumerationTab.this.updateRemoveButton(false);
                        }
                        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)"Removed Enumeration Index ");
                    }
                });
            }
            catch (DatabaseException e1) {
                e1.printStackTrace();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }

    private class ShowAllIndexesListener
    implements SelectionListener,
    Widget {
        Resource enumerationIndexes;

        public ShowAllIndexesListener(WidgetSupport support) {
            support.register((Widget)this);
        }

        public void setInput(ISessionContext context, Object input) {
            final Resource enumeration = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
            context.getSession().asyncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    if (!graph.hasStatement(enumeration)) {
                        return null;
                    }
                    SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                    ShowAllIndexesListener.this.enumerationIndexes = graph.getSingleObject(enumeration, sr.Enumeration_enumerationIndexList);
                    List indexes = ListUtils.toList((ReadGraph)graph, (Resource)ShowAllIndexesListener.this.enumerationIndexes);
                    for (Resource index : indexes) {
                        Boolean show = (Boolean)graph.getPossibleRelatedValue(index, sr.EnumerationIndex_showEnumerationIndexInCharts, (Binding)Bindings.BOOLEAN);
                        if (Boolean.TRUE.equals(show)) continue;
                        return false;
                    }
                    return true;
                }
            }, (org.simantics.db.procedure.Listener)new org.simantics.db.procedure.Listener<Boolean>(){

                public void execute(final Boolean result) {
                    ((ShowAllIndexesListener)ShowAllIndexesListener.this).EnumerationTab.this.showAll.getWidget().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (result != null && !((ShowAllIndexesListener)(this).ShowAllIndexesListener.this).EnumerationTab.this.showAll.getWidget().isDisposed()) {
                                ((ShowAllIndexesListener)(this).ShowAllIndexesListener.this).EnumerationTab.this.showAll.getWidget().setSelection(result.booleanValue());
                            }
                        }
                    });
                }

                public void exception(Throwable t) {
                    t.printStackTrace();
                }

                public boolean isDisposed() {
                    if (((ShowAllIndexesListener)ShowAllIndexesListener.this).EnumerationTab.this.showAll == null) {
                        return true;
                    }
                    return ((ShowAllIndexesListener)ShowAllIndexesListener.this).EnumerationTab.this.showAll.getWidget().isDisposed();
                }
            });
        }

        public void widgetSelected(SelectionEvent e) {
            final boolean selected = EnumerationTab.this.showAll.getWidget().getSelection();
            try {
                Simantics.getSession().syncRequest((Write)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        graph.markUndoPoint();
                        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
                        List indexes = ListUtils.toList((ReadGraph)graph, (Resource)ShowAllIndexesListener.this.enumerationIndexes);
                        for (Resource index : indexes) {
                            Boolean show = (Boolean)graph.getPossibleRelatedValue(index, sr.EnumerationIndex_showEnumerationIndexInCharts, (Binding)Bindings.BOOLEAN);
                            if (selected && !Boolean.TRUE.equals(show)) {
                                graph.claimLiteral(index, sr.EnumerationIndex_showEnumerationIndexInCharts, (Object)true, (Binding)Bindings.BOOLEAN);
                                continue;
                            }
                            if (selected || Boolean.FALSE.equals(show)) continue;
                            graph.claimLiteral(index, sr.EnumerationIndex_showEnumerationIndexInCharts, (Object)false, (Binding)Bindings.BOOLEAN);
                        }
                        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)"Modified Show all in charts");
                        EnumerationTab.this.updateModelResults((ReadGraph)graph);
                    }
                });
            }
            catch (DatabaseException e1) {
                e1.printStackTrace();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

