/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.game;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.menus.UIElement;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.manager.SysdynGameExperimentBase;
import org.simantics.sysdyn.ui.handlers.RunBasicExperiment;
import org.simantics.ui.SimanticsUI;

public class ReloadGameExperimentHandler
extends RunBasicExperiment {
    private boolean started = false;
    private boolean initialized = false;
    public static final String COMMAND = "org.simantics.sysdyn.ui.reloadGame";

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        SysdynGameExperimentBase game = this.getGameExperiment();
        if (game != null) {
            game.simulate(true);
        }
        return null;
    }

    private SysdynGameExperimentBase getGameExperiment() {
        IProject project = SimanticsUI.peekProject();
        if (project == null) {
            return null;
        }
        IExperimentManager manager = (IExperimentManager)project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment active = manager.getActiveExperiment();
        if (!(active instanceof SysdynGameExperimentBase)) {
            return null;
        }
        return (SysdynGameExperimentBase)active;
    }

    @Override
    public void updateElement(UIElement element, Map parameters) {
        super.updateElement(element, parameters);
        SysdynGameExperimentBase game = this.getGameExperiment();
        if (game == null) {
            this.started = false;
            this.initialized = false;
            return;
        }
        ExperimentState state = game.getState();
        if (state == ExperimentState.INITIALIZING) {
            this.started = false;
            this.initialized = false;
        } else if (state == ExperimentState.RUNNING) {
            this.started = true;
            this.initialized = false;
        } else if (state == ExperimentState.STOPPED && this.started && !this.initialized) {
            this.initialized = true;
        }
        if (this.initialized) {
            element.setTooltip("Reload Game");
        } else {
            element.setTooltip("Initialize Game");
        }
    }
}

