/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.exports;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleRelatedValue;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.modelExport.SysdynModelExporter;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.utils.imports.ImportUtilsUI;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ExportModelHandler
extends AbstractHandler {
    protected static IStatusLineManager status;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        status = WorkbenchUtils.getStatusLine((IWorkbenchSite)HandlerUtil.getActiveSite((ExecutionEvent)event));
        Resource model = this.determineModel(event);
        if (model == null) {
            return null;
        }
        String selected = this.getAbsolutePath(model, event, true);
        if (selected != null) {
            this.createFile(model, selected);
            this.setExportStatus(model, selected);
        }
        return null;
    }

    protected void setExportStatus(final Resource model, String fileName) {
        try {
            String modelName = (String)SimanticsUI.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    if (!graph.hasStatement(model, Layer0.getInstance((ReadGraph)graph).PartOf)) {
                        return null;
                    }
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    return (String)graph.syncRequest((Read)new PossibleRelatedValue(model, l0.HasName, (Binding)Bindings.STRING));
                }
            });
            if (modelName != null) {
                ExportModelHandler.setStatus("Saved model \"" + modelName + "\" to " + fileName);
            }
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
    }

    protected void createFile(Resource model, String fileName) {
        File exportLocation = new File(fileName);
        try {
            SysdynModelExporter.exportModel((IProgressMonitor)new NullProgressMonitor(), (Resource)model, (File)exportLocation, (String)"", (boolean)false);
        }
        catch (InvocationTargetException e1) {
            ExceptionUtils.logAndShowError((String)"Model Export Failed", (String)"Sysdyn model export failed, see exception for details", (Throwable)e1);
        }
    }

    protected Resource determineModel(ExecutionEvent event) {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Resource model = ResourceAdaptionUtils.toSingleResource((Object)sel);
        return model;
    }

    protected String getAbsolutePath(final Resource model, ExecutionEvent event, boolean saveAs) throws ExecutionException {
        String path = null;
        try {
            path = (String)SimanticsUI.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    if (!graph.hasStatement(model, Layer0.getInstance((ReadGraph)graph).PartOf)) {
                        return null;
                    }
                    SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                    String path = (String)graph.syncRequest((Read)new PossibleRelatedValue(model, SR.SysdynModel_lastExportFilePath, (Binding)Bindings.STRING));
                    return path;
                }
            });
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        if (path == null) {
            if (!saveAs) {
                return this.getAbsolutePath(model, event, true);
            }
            path = Activator.getDefault().getPreferenceStore().getString(ImportUtilsUI.IMPORTMODELTPATH);
        }
        if (!saveAs && !new File(path).exists()) {
            return this.getAbsolutePath(model, event, true);
        }
        if (path.isEmpty() || !new File(path).exists()) {
            path = Platform.getLocation().toOSString();
        }
        String name = null;
        try {
            name = (String)SimanticsUI.getSession().syncRequest((Read)new Read<String>(){

                public String perform(ReadGraph graph) throws DatabaseException {
                    if (!graph.hasStatement(model, Layer0.getInstance((ReadGraph)graph).PartOf)) {
                        return null;
                    }
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                    String name = (String)graph.syncRequest((Read)new PossibleRelatedValue(model, SR.SysdynModel_lastExportFileName, (Binding)Bindings.STRING));
                    if (name == null) {
                        name = (String)graph.syncRequest((Read)new PossibleRelatedValue(model, l0.HasName, (Binding)Bindings.STRING));
                    }
                    return name;
                }
            });
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        if (name == null) {
            return null;
        }
        String fullPath = null;
        if (saveAs) {
            Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
            FileDialog fd = new FileDialog(shell, 8192);
            fd.setText("Export Model");
            fd.setFileName(name);
            fd.setFilterPath(path);
            String[] filterExt = new String[]{"*.sysdyn"};
            fd.setFilterExtensions(filterExt);
            fd.setOverwrite(true);
            fullPath = fd.open();
        } else {
            fullPath = path;
            if (path.charAt(path.length() - 1) != '\\') {
                fullPath = String.valueOf(fullPath) + "\\";
            }
            fullPath = String.valueOf(fullPath) + name;
        }
        final String selected = fullPath;
        if (selected == null) {
            return null;
        }
        try {
            SimanticsUI.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
                    graph.deny(model, SR.SysdynModel_lastExportFilePath);
                    graph.deny(model, SR.SysdynModel_lastExportFileName);
                    graph.addLiteral(model, SR.SysdynModel_lastExportFilePath, SR.SysdynModel_lastExportFilePath_Inverse, l0.String, (Object)new File(selected).getParent(), (Binding)Bindings.STRING);
                    graph.addLiteral(model, SR.SysdynModel_lastExportFileName, SR.SysdynModel_lastExportFilePath_Inverse, l0.String, (Object)new File(selected).getName(), (Binding)Bindings.STRING);
                }
            });
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
        }
        return selected;
    }

    protected static void setStatus(String message) {
        if (status != null) {
            status.setMessage(message);
        }
    }
}

