/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers.exports;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.platform.PropertyPageView;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.sysdyn.ui.handlers.exports.ExportModelHandler;
import org.simantics.sysdyn.ui.utils.SysdynWorkbenchUtils;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ExportModelButtonHandler
extends ExportModelHandler {
    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        status = WorkbenchUtils.getStatusLine((IWorkbenchSite)HandlerUtil.getActiveSite((ExecutionEvent)event));
        Resource model = this.determineModel(event);
        if (model == null) {
            return null;
        }
        String selected = this.getAbsolutePath(model, event, false);
        if (selected != null) {
            this.createFile(model, selected);
            this.setExportStatus(model, selected);
        }
        return null;
    }

    @Override
    protected Resource determineModel(ExecutionEvent event) {
        Resource model;
        Object element;
        AbstractNode a;
        IStructuredSelection iss;
        Resource inputResource;
        IWorkbenchPart activePart;
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel == null && (activePart = HandlerUtil.getActivePart((ExecutionEvent)event)) instanceof PropertyPageView) {
            sel = ((PropertyPageView)activePart).getLastSelection();
        }
        if ((inputResource = ResourceAdaptionUtils.toSingleResource((Object)sel)) == null && sel instanceof IStructuredSelection && (iss = (IStructuredSelection)sel).size() == 1 && (a = (AbstractNode)AdaptionUtils.adaptToSingle((Object)(element = iss.getFirstElement()), AbstractNode.class)) != null) {
            inputResource = (Resource)a.data;
        }
        if (inputResource == null) {
            IWorkbenchPage page = SysdynWorkbenchUtils.getActivePageOfEditor();
            DiagramEditor editor = (DiagramEditor)page.getActiveEditor();
            if (editor != null && editor instanceof DiagramEditor) {
                inputResource = editor.getInputResource();
            } else {
                return null;
            }
        }
        final Resource resource = inputResource;
        try {
            model = (Resource)SimanticsUI.getSession().syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    return (Resource)graph.sync((ReadInterface)new PossibleModel(resource));
                }
            });
            if (model == null) {
                return null;
            }
        }
        catch (DatabaseException e1) {
            e1.printStackTrace();
            return null;
        }
        return model;
    }
}

