/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.simantics.simulation.experiment.ExperimentState;
import org.simantics.simulation.experiment.IDynamicExperiment;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.sysdyn.manager.SysdynExperiment;
import org.simantics.sysdyn.ui.utils.HandlerUtils;
import org.simantics.ui.SimanticsUI;

public class RunBasicExperiment
extends AbstractHandler
implements IElementUpdater {
    public static final String COMMAND = "org.simantics.sysdyn.ui.run";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        HandlerUtils.saveBeforeExperimentRun(event);
        IExperimentManager manager = (IExperimentManager)SimanticsUI.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment instanceof IDynamicExperiment) {
            ((IDynamicExperiment)experiment).simulate(true);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IExperimentManager manager = (IExperimentManager)SimanticsUI.getProject().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        IExperiment experiment = manager.getActiveExperiment();
        if (experiment instanceof SysdynExperiment) {
            ExperimentState state = experiment.getState();
            if (state == ExperimentState.RUNNING) {
                this.setBaseEnabled(false);
            } else {
                this.setBaseEnabled(true);
            }
        }
    }
}

