/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.handlers;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.simantics.sysdyn.ui.handlers.FindSearchTrim;

public class FindReplaceDialog
extends Dialog {
    private FindSearchTrim search;
    private Button scopeButtonAllModels;
    private Button scopeButtonCurrentDiagram;
    private FindSearchTrim.Scope scope;
    private boolean diagramOpen;

    protected FindReplaceDialog(Shell parentShell, FindSearchTrim.Scope scope, boolean diagramOpen) {
        super(parentShell);
        this.setBlockOnOpen(false);
        this.scope = scope;
        this.diagramOpen = diagramOpen;
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.getShell().setText("Find");
        GridLayoutFactory.fillDefaults().margins(5, 5).numColumns(2).applyTo(composite);
        Label label = new Label(composite, 0);
        label.setText("Find: ");
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).hint(40, -1).applyTo((Control)label);
        this.search = new FindSearchTrim(composite);
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)this.search);
        Group scopeGroup = new Group(composite, 32);
        scopeGroup.setText("Scope");
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)scopeGroup);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo((Composite)scopeGroup);
        Composite scopeComposite = new Composite((Composite)scopeGroup, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)scopeComposite);
        GridLayoutFactory.fillDefaults().applyTo(scopeComposite);
        this.scopeButtonCurrentDiagram = new Button(scopeComposite, 16);
        this.scopeButtonCurrentDiagram.setText("Current Diagram");
        this.scopeButtonCurrentDiagram.setSelection(this.scope == FindSearchTrim.Scope.CURRENT_DIAGRAM);
        this.scopeButtonCurrentDiagram.setEnabled(this.diagramOpen);
        GridDataFactory.fillDefaults().applyTo((Control)this.scopeButtonCurrentDiagram);
        this.scopeButtonAllModels = new Button(scopeComposite, 16);
        this.scopeButtonAllModels.setText("All Models");
        this.scopeButtonAllModels.setSelection(this.scope == FindSearchTrim.Scope.ALL_MODELS);
        GridDataFactory.fillDefaults().applyTo((Control)this.scopeButtonAllModels);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Find", true);
        this.createButton(parent, 1, "Close", false);
    }

    protected void cancelPressed() {
        this.setReturnCode(1);
        this.close();
    }

    protected void okPressed() {
        this.scope = this.scopeButtonAllModels.getSelection() ? FindSearchTrim.Scope.ALL_MODELS : (this.scopeButtonCurrentDiagram.getSelection() ? FindSearchTrim.Scope.CURRENT_DIAGRAM : FindSearchTrim.Scope.ALL_MODELS);
        this.search.findNameAndTypeQuery(this.scope);
        this.setReturnCode(0);
        this.close();
    }
}

