/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.elements.profiles;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.utils.ListUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.request.AsyncRead;
import org.simantics.db.request.Read;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.issues.common.ErrorIssues;
import org.simantics.issues.common.FatalIssues;
import org.simantics.issues.common.WarningIssues;
import org.simantics.issues.ontology.IssueResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.SVGNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.Observer;
import org.simantics.scenegraph.profile.common.ProfileVariables;
import org.simantics.scenegraph.utils.NodeUtil;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.Activator;
import org.simantics.sysdyn.ui.elements.profiles.IssueResult;

public class IssueDecorationStyle
extends StyleBase<IssueResult> {
    private static final String DECORATION_NODE_NAME = "issueDecorations";

    public IssueResult calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource element, Variable configuration) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        Resource component = graph.getPossibleObject(element, MOD.ElementToComponent);
        if (component != null && graph.isInstanceOf(component, SR.Shadow)) {
            component = graph.getPossibleObject(component, SR.Shadow_original);
        }
        if (component == null) {
            return null;
        }
        AffineTransform transform = DiagramGraphUtil.getAffineTransform((ReadGraph)graph, (Resource)element);
        Resource model = (Resource)graph.syncRequest((AsyncRead)new PossibleTypedParent(component, SimulationResource.getInstance((ReadGraph)graph).Model));
        if (model == null) {
            return null;
        }
        Resource project = graph.getPossibleObject(model, L0.PartOf);
        if (project == null) {
            return null;
        }
        IssueResult result = null;
        Set fatals = (Set)graph.syncRequest((Read)new FatalIssues(project, true));
        result = this.getIssue(graph, IssueResult.Severity.FATAL, fatals, component, transform);
        if (result != null) {
            return result;
        }
        Set errors = (Set)graph.syncRequest((Read)new ErrorIssues(project, true));
        result = this.getIssue(graph, IssueResult.Severity.ERROR, errors, component, transform);
        if (result != null) {
            return result;
        }
        Set warnings = (Set)graph.syncRequest((Read)new WarningIssues(project, true));
        result = this.getIssue(graph, IssueResult.Severity.WARNING, warnings, component, transform);
        if (result != null) {
            return result;
        }
        return null;
    }

    private IssueResult getIssue(ReadGraph graph, IssueResult.Severity severity, Set<Variable> issues, Resource component, AffineTransform transform) throws DatabaseException {
        IssueResource ISSUE = IssueResource.getInstance((ReadGraph)graph);
        for (Variable issue : issues) {
            Resource issueResource = issue.getRepresents(graph);
            Resource list = graph.getPossibleObject(issueResource, ISSUE.Issue_HasContexts);
            List contexts = ListUtils.toList((ReadGraph)graph, (Resource)list);
            if (contexts.isEmpty() || !ListUtils.toList((ReadGraph)graph, (Resource)list).subList(0, 1).contains(component)) continue;
            return new IssueResult(severity, transform);
        }
        return null;
    }

    public void applyStyleForNode(EvaluationContext observer, INode node, IssueResult result) {
        if (result == null) {
            ProfileVariables.denyChild((INode)node, (String)"", (String)DECORATION_NODE_NAME);
            return;
        }
        SVGNode svgNode = (SVGNode)ProfileVariables.claimChild((INode)node, (String)"", (String)DECORATION_NODE_NAME, SVGNode.class, (Observer)observer);
        Rectangle2D bounds = NodeUtil.getLocalBounds((INode)node, Collections.singleton(svgNode));
        double tx = bounds.getMaxX();
        double ty = bounds.getY();
        svgNode.setZIndex(Integer.MAX_VALUE);
        svgNode.setTransform(AffineTransform.getTranslateInstance(tx - 1.0, ty - 1.0));
        svgNode.getTransform().scale(0.5, 0.5);
        IssueResult.Severity sev = result.getSeverity();
        if (IssueResult.Severity.FATAL.equals((Object)sev)) {
            svgNode.setData(Activator.FATAL_SVG_TEXT);
        } else if (IssueResult.Severity.ERROR.equals((Object)sev)) {
            svgNode.setData(Activator.ERROR_SVG_TEXT);
        } else if (IssueResult.Severity.WARNING.equals((Object)sev)) {
            svgNode.setData(Activator.WARNING_SVG_TEXT);
        }
    }

    protected void cleanupStyleForNode(INode node) {
        ProfileVariables.denyChild((INode)node, (String)"", (String)DECORATION_NODE_NAME);
    }
}

