/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PossibleModel;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.flag.FlagUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ComponentUtils;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.actions.NavigateToTarget;
import org.simantics.modeling.ui.Activator;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.utils.threads.IThreadWorkQueue;
import org.simantics.utils.threads.ThreadUtils;
import org.simantics.utils.ui.AdaptionUtils;

public class OpenDiagramFromComponentAdapter
extends AbstractResourceEditorAdapter {
    private static final String EDITOR_ID = "org.simantics.sysdyn.ui.diagramViewer";

    public OpenDiagramFromComponentAdapter() {
        super("Diagram Editor", Activator.COMPOSITE_ICON);
    }

    public boolean canHandle(ReadGraph graph, Object input) throws DatabaseException {
        Collection rs = (Collection)graph.syncRequest((Read)new DiagramFinderRequest(input), (AsyncProcedure)TransientCacheAsyncListener.instance());
        return !rs.isEmpty();
    }

    private Resource tryGetResource(ReadGraph graph, Object input) throws DatabaseException {
        Resource r = ResourceAdaptionUtils.toSingleResource((Object)input);
        if (r == null) {
            Variable v = (Variable)AdaptionUtils.adaptToSingle((Object)input, Variable.class);
            r = this.findResource(graph, v);
        }
        return r;
    }

    private Resource findResource(ReadGraph graph, Variable v) throws DatabaseException {
        while (v != null) {
            Resource r = v.getPossibleRepresents(graph);
            if (r != null) {
                return r;
            }
            v = v.browsePossible(graph, ".");
        }
        return null;
    }

    public void openEditor(Object input) throws Exception {
        Display d = Display.getCurrent();
        if (d == null) {
            return;
        }
        Collection rs = (Collection)Simantics.getSession().syncRequest((Read)new DiagramFinderRequest(input), (AsyncProcedure)TransientCacheAsyncListener.instance());
        for (Runnable runnable : rs) {
            runnable.run();
        }
    }

    private Collection<Runnable> tryFindDiagram(ReadGraph g, Resource module, Variable variable) throws DatabaseException {
        try {
            return this.findDiagram(g, module, variable);
        }
        catch (DatabaseException databaseException) {
            return Collections.emptyList();
        }
    }

    private Collection<Runnable> findDiagram(ReadGraph g, Resource module, Variable variable) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
        SysdynResource SYSDYN = SysdynResource.getInstance((ReadGraph)g);
        if (g.isInstanceOf(module, SYSDYN.IndependentVariable) || g.isInstanceOf(module, SYSDYN.Input) || g.isInstanceOf(module, SYSDYN.Module)) {
            Variable parent;
            Variable context;
            ArrayList<Runnable> result = new ArrayList<Runnable>(1);
            Variable moduleVariable = Variables.getVariable((ReadGraph)g, (Resource)module);
            RVI rvi = moduleVariable.getRVI(g);
            Resource composite = g.getSingleObject(module, l0.PartOf);
            Resource model = (Resource)g.syncRequest((Read)new PossibleModel(composite));
            Resource diagram = ComponentUtils.getCompositeDiagram((ReadGraph)g, (Resource)composite);
            if (variable != null && (context = Variables.getPossibleContext((ReadGraph)g, (Variable)variable)) != null && (parent = variable.getParent(g)) != null) {
                rvi = parent.getRVI(g);
                model = Variables.getModel((ReadGraph)g, (Variable)context);
            }
            final Collection<Object> selectedObjects = OpenDiagramFromComponentAdapter.findElementObjects(g, module);
            result.add(NavigateToTarget.editorActivator((String)EDITOR_ID, (Resource)diagram, (Resource)model, (RVI)rvi, (Consumer)new Consumer<IEditorPart>(){

                @Override
                public void accept(IEditorPart part) {
                    ICanvasContext openedCanvas = (ICanvasContext)part.getAdapter(ICanvasContext.class);
                    if (!$assertionsDisabled && openedCanvas == null) {
                        throw new AssertionError();
                    }
                    openedCanvas.getDefaultHintContext().setHint(DiagramHints.KEY_INITIAL_ZOOM_TO_FIT, (Object)Boolean.FALSE);
                    ThreadUtils.asyncExec((IThreadWorkQueue)openedCanvas.getThreadAccess(), (Runnable)NavigateToTarget.elementSelectorZoomer((ICanvasContext)openedCanvas, (Collection)selectedObjects, (boolean)false));
                }
            }));
            return result;
        }
        return Collections.emptyList();
    }

    public static Collection<Object> findElementObjects(ReadGraph g, Resource module) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)g);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)g);
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        for (Resource element : g.getObjects(module, MOD.ComponentToElement)) {
            if (g.isInstanceOf(element, DIA.Flag) && FlagUtil.isExternal((ReadGraph)g, (Resource)element)) {
                selectedObjects.clear();
                selectedObjects.add(element);
                break;
            }
            if (g.isInstanceOf(element, DIA.RouteGraphConnection)) {
                selectedObjects.add(element);
                continue;
            }
            if (g.isInstanceOf(element, DIA.Connection)) {
                ConnectionUtil cu = new ConnectionUtil(g);
                cu.gatherConnectionParts(element, selectedObjects);
                continue;
            }
            selectedObjects.add(element);
        }
        for (Resource element : g.getObjects(module, MOD.HasParentComponent_Inverse)) {
            selectedObjects.add(element);
        }
        return selectedObjects;
    }

    private class DiagramFinderRequest
    extends UnaryRead<Object, Collection<Runnable>> {
        public DiagramFinderRequest(Object parameter) {
            super(parameter);
        }

        public Collection<Runnable> perform(ReadGraph graph) throws DatabaseException {
            Resource r = OpenDiagramFromComponentAdapter.this.tryGetResource(graph, this.parameter);
            if (r == null) {
                return Collections.emptyList();
            }
            Variable v = (Variable)AdaptionUtils.adaptToSingle((Object)this.parameter, Variable.class);
            return OpenDiagramFromComponentAdapter.this.tryFindDiagram(graph, r, v);
        }
    }
}

