/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import java.util.Collection;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IDeletableNode;
import org.simantics.browsing.ui.common.node.IDoubleClickableNode;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.browser.nodes.SimulationResultNode;
import org.simantics.sysdyn.ui.handlers.ToggleResultSetActivation;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ExceptionUtils;

public class SimulationResultSetNode
extends AbstractNode<Resource>
implements IDoubleClickableNode,
IDeletableNode,
IModifiableNode {
    public SimulationResultSetNode(Resource resource) {
        super((Object)resource);
    }

    public Labeler.Modifier getModifier(String columnId) {
        LabelModifier modifier = new LabelModifier(SimanticsUI.getSession(), (Resource)this.data){

            public String isValid(String label) {
                if (label.isEmpty()) {
                    return "Empty label not allowed";
                }
                return null;
            }
        };
        return modifier;
    }

    public void delete() throws DeleteException {
        try {
            SimanticsUI.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException, CancelTransactionException {
                    SimulationResultSetNode.unlinkResultSet(graph, (Resource)SimulationResultSetNode.this.data);
                }
            });
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }

    public static void unlinkResultSet(WriteGraph graph, Resource resultSet) throws DatabaseException {
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        for (Resource result : (Collection)graph.syncRequest((Read)new ObjectsWithType(resultSet, sr.Experiment_result, sr.Result))) {
            SimulationResultNode.unlinkResult(graph, result);
        }
        RemoverUtil.remove((WriteGraph)graph, (Resource)resultSet);
    }

    public boolean handleDoubleClick() {
        Resource[] resources = new Resource[]{(Resource)this.data};
        ToggleResultSetActivation.toggleActivation(resources);
        return true;
    }
}

