/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import java.io.File;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IDeletableNode;
import org.simantics.browsing.ui.common.node.IDoubleClickableNode;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Write;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.handlers.ToggleResultActivation;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ExceptionUtils;

public class SimulationResultNode<T>
extends AbstractNode<Resource>
implements IDoubleClickableNode,
IDeletableNode,
IModifiableNode {
    public SimulationResultNode(Resource resource) {
        super((Object)resource);
    }

    public Labeler.Modifier getModifier(String columnId) {
        LabelModifier modifier = new LabelModifier(SimanticsUI.getSession(), (Resource)this.data){

            public String isValid(String label) {
                if (label.isEmpty()) {
                    return "Empty label not allowed";
                }
                return null;
            }
        };
        return modifier;
    }

    public void delete() throws DeleteException {
        try {
            SimanticsUI.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException, CancelTransactionException {
                    SimulationResultNode.unlinkResult(graph, (Resource)SimulationResultNode.this.data);
                }
            });
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }

    public static void unlinkResult(WriteGraph graph, Resource result) throws DatabaseException {
        SimulationResultNode.deleteResultFiles(graph, result);
        RemoverUtil.remove((WriteGraph)graph, (Resource)result);
    }

    public static void deleteResultFiles(WriteGraph graph, Resource result) throws DatabaseException {
        String path = (String)graph.getPossibleRelatedValue(result, SysdynResource.getInstance((ReadGraph)graph).Result_resultFile);
        if (path != null) {
            File file = new File(path);
            file.delete();
            File parent = file.getParentFile();
            if (parent.listFiles() != null && parent.listFiles().length == 0) {
                parent.delete();
            }
        }
    }

    public boolean handleDoubleClick() {
        Resource[] resources = new Resource[]{(Resource)this.data};
        ToggleResultActivation.toggleActivation(resources);
        return true;
    }
}

