/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.nodes;

import org.simantics.Simantics;
import org.simantics.browsing.ui.common.node.AbstractNode;
import org.simantics.browsing.ui.common.node.DeleteException;
import org.simantics.browsing.ui.common.node.IDeletableNode;
import org.simantics.browsing.ui.common.node.IDoubleClickableNode;
import org.simantics.browsing.ui.common.node.IModifiableNode;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.browsing.ui.graph.impl.LabelModifier;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.sysdyn.ui.browser.nodes.SimulationResultNode;
import org.simantics.sysdyn.ui.utils.ModelNameValidator;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ExceptionUtils;

public class ModelNode
extends AbstractNode<Resource>
implements IDoubleClickableNode,
IDeletableNode,
IModifiableNode {
    Listener<String> configurationNameSynchronizer = new Listener<String>(){

        public void execute(final String result) {
            if (result == null) {
                return;
            }
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    SimulationResource sim = SimulationResource.getInstance((ReadGraph)graph);
                    Resource configuration = graph.getPossibleObject((Resource)(this).ModelNode.this.data, sim.HasConfiguration);
                    String label = (String)graph.getPossibleRelatedValue2(configuration, l0.HasLabel, (Binding)Bindings.STRING);
                    if (label != null) {
                        return;
                    }
                    graph.claimLiteral(configuration, l0.HasLabel, (Object)result);
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Created ModelNode to model browser for model " + result));
                }
            });
        }

        public void exception(Throwable t) {
            t.printStackTrace();
        }

        public boolean isDisposed() {
            return ModelNode.this.disposed;
        }
    };
    private boolean disposed = false;

    public ModelNode(Resource resource) {
        super((Object)resource);
        SimanticsUI.getSession().asyncRequest((Read)new Read<String>(){

            public String perform(ReadGraph graph) throws DatabaseException {
                return (String)graph.getPossibleRelatedValue((Resource)ModelNode.this.data, Layer0.getInstance((ReadGraph)graph).HasLabel);
            }
        }, this.configurationNameSynchronizer);
    }

    public Labeler.Modifier getModifier(String columnId) {
        LabelModifier modifier = new LabelModifier(SimanticsUI.getSession(), (Resource)this.data){

            public String isValid(String label) {
                if (!new ModelNameValidator().isValid((Resource)ModelNode.this.data, label)) {
                    return "Not valid";
                }
                return null;
            }

            protected Write getWriteRequest(final String label) {
                return new WriteRequest(){

                    public void perform(WriteGraph g) throws DatabaseException {
                        g.markUndoPoint();
                        Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                        String oldName = (String)g.getPossibleRelatedValue2((Resource)(this).ModelNode.this.data, l0.HasLabel, (Binding)Bindings.STRING);
                        g.claimLiteral((Resource)(this).ModelNode.this.data, l0.HasLabel, (Object)label);
                        String safeName = NameUtils.findFreshName((ReadGraph)g, (String)label, (Resource)g.getSingleObject((Resource)(this).ModelNode.this.data, l0.PartOf), (Resource)l0.ConsistsOf, (String)"%s%d");
                        g.claimLiteral((Resource)(this).ModelNode.this.data, l0.HasName, (Object)safeName);
                        Layer0Utils.addCommentMetadata((WriteOnlyGraph)g, (String)("Renamed model " + oldName + " to " + label + " " + ((Resource)(this).ModelNode.this.data).toString()));
                    }
                };
            }
        };
        return modifier;
    }

    public void delete() throws DeleteException {
        this.disposed = true;
        try {
            SimanticsUI.getSession().syncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException, CancelTransactionException {
                    graph.markUndoPoint();
                    Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                    for (Resource r : graph.getObjects((Resource)ModelNode.this.data, l0.ConsistsOf)) {
                        if (!graph.isInstanceOf(r, SysdynResource.getInstance((ReadGraph)graph).Result)) continue;
                        SimulationResultNode.deleteResultFiles(graph, r);
                    }
                    String modelName = (String)graph.getPossibleRelatedValue2((Resource)ModelNode.this.data, l0.HasName, (Binding)Bindings.STRING);
                    String modelResource = ((Resource)ModelNode.this.data).toString();
                    RemoverUtil.remove((WriteGraph)graph, (Resource)((Resource)ModelNode.this.data));
                    Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Removed model '" + modelName + "' " + modelResource));
                }
            });
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }

    public boolean handleDoubleClick() {
        return false;
    }
}

