/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.childrules;

import java.util.ArrayList;
import java.util.Collection;
import org.simantics.browsing.ui.model.children.ChildRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.sysdyn.SysdynResource;

public class VariableChildRule
implements ChildRule {
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Variable.class) || contentType.equals(Resource.class);
    }

    public Collection<?> getChildren(ReadGraph graph, Object parent) throws DatabaseException {
        ArrayList<Variable> result = new ArrayList<Variable>();
        if (parent == null) {
            return result;
        }
        Variable variable = null;
        if (parent instanceof Variable) {
            variable = (Variable)parent;
        } else if (parent instanceof Resource) {
            variable = Variables.getVariable((ReadGraph)graph, (Resource)((Resource)parent));
        }
        if (variable == null) {
            return result;
        }
        SysdynResource sr = SysdynResource.getInstance((ReadGraph)graph);
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Variable child : variable.getChildren(graph)) {
            Resource represents = child.getRepresents(graph);
            if (graph.isInstanceOf(represents, sr.IndependentVariable)) {
                variables.add(child);
                continue;
            }
            if (graph.isInstanceOf(represents, sr.Input)) {
                variables.add(child);
                continue;
            }
            if (graph.isInstanceOf(represents, sr.Module)) {
                variables.add(child);
                continue;
            }
            if (!graph.isInstanceOf(represents, sr.Enumeration)) continue;
            variables.add(child);
        }
        for (Variable v : variables) {
            result.add(v);
        }
        return result;
    }

    public Collection<?> getParents(ReadGraph graph, Object child) throws DatabaseException {
        return null;
    }
}

