/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.browser.actions.newActions;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.Write;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.direct.GraphUtils;
import org.simantics.sysdyn.SysdynResource;
import org.simantics.ui.SimanticsUI;

public class NewFunctionLibraryAction
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        final Resource resource = (Resource)target;
        return new Runnable(){

            @Override
            public void run() {
                NewFunctionLibraryAction.createLibrary(resource, false);
            }
        };
    }

    protected static void createLibrary(final Resource libraryLocation, final boolean shared) {
        SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph g) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                SysdynResource sr = SysdynResource.getInstance((ReadGraph)g);
                if (!(g.isInstanceOf(libraryLocation, sr.SysdynModel) || g.isInstanceOf(libraryLocation, sr.SysdynModelicaFunctionLibrary) || g.isInstanceOf(libraryLocation, sr.SharedFunctionOntology))) {
                    return;
                }
                Resource root = libraryLocation;
                String name = "FunctionLibrary";
                Resource libraryType = sr.SysdynModelicaFunctionLibrary;
                if (shared) {
                    try {
                        root = g.getResource("http://SharedOntologies");
                    }
                    catch (ResourceNotFoundException resourceNotFoundException) {
                        root = g.getResource("http:/");
                        root = GraphUtils.create2((WriteGraph)g, (Resource)l0.Library, (Object[])new Object[]{l0.HasName, "SharedOntologies", l0.PartOf, root});
                    }
                    name = "Shared" + name;
                    libraryType = sr.SharedFunctionOntology;
                }
                name = NameUtils.findFreshName((ReadGraph)g, (String)name, (Resource)root, (Resource)l0.ConsistsOf, (String)"%s%d");
                Resource functionLibrary = GraphUtils.create2((WriteGraph)g, (Resource)libraryType, (Object[])new Object[]{l0.HasName, name, l0.HasDescription, "", l0.PartOf, root});
                if (shared) {
                    g.claim(libraryLocation, l0.IsLinkedTo, functionLibrary);
                }
            }
        });
    }
}

