/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.sysdyn.ui.actions;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ObjectsWithSupertype;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Instances;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.project.ontology.ProjectResource;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.sysdyn.SysdynResource;

public class SysdynVariableRemover
implements Remover {
    private Resource resource;

    public SysdynVariableRemover(Resource resource) {
        this.resource = resource;
    }

    public String canRemove(ReadGraph graph, Map<Object, Object> aux) throws DatabaseException {
        return null;
    }

    public void remove(WriteGraph graph) throws DatabaseException {
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        if (graph.hasStatement(this.resource, SR.IsOutput) || graph.isInstanceOf(this.resource, SR.Input)) {
            Resource moduleType;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            ProjectResource PROJ = ProjectResource.getInstance((ReadGraph)graph);
            Resource configuration = graph.getPossibleObject(this.resource, L0.PartOf);
            if (configuration != null && graph.isInheritedFrom(moduleType = graph.getPossibleObject(configuration, L0.PartOf), SR.Module)) {
                Resource project = moduleType;
                while ((project = graph.getPossibleObject(project, L0.PartOf)) != null && !graph.isInstanceOf(project, PROJ.Project)) {
                }
                if (project != null) {
                    for (Resource model : (Collection)graph.syncRequest((Read)new ObjectsWithType(project, L0.ConsistsOf, SR.SysdynModel))) {
                        this.removeOutputReferencesFromModel(graph, model, this.resource, moduleType);
                    }
                }
            }
        }
        for (Resource shadow : graph.getObjects(this.resource, SR.Shadow_original_Inverse)) {
            Resource element = graph.getPossibleObject(shadow, ModelingResources.getInstance((ReadGraph)graph).ComponentToElement);
            if (element == null) continue;
            RemoverUtil.remove((WriteGraph)graph, (Resource)element);
        }
        EntityRemover.remove((WriteGraph)graph, (Resource)this.resource);
    }

    private void removeOutputReferencesFromModel(WriteGraph graph, Resource model, Resource reference, Resource moduleType) throws DatabaseException {
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        StructuralResource2 SR2 = StructuralResource2.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Instances moduleInstanceFinder = (Instances)graph.adapt(moduleType, Instances.class);
        this.denyReferences(graph, moduleInstanceFinder, graph.getPossibleObject(model, SimulationResource.getInstance((ReadGraph)graph).HasConfiguration), reference);
        for (Resource type : (Set)graph.syncRequest((Read)new ObjectsWithSupertype(model, L0.ConsistsOf, SR.Module))) {
            Resource configuration = graph.getPossibleObject(type, SR2.IsDefinedBy);
            this.denyReferences(graph, moduleInstanceFinder, configuration, reference);
        }
    }

    private void denyReferences(WriteGraph graph, Instances moduleInstanceFinder, Resource indexRoot, Resource reference) throws DatabaseException {
        StructuralResource2 SR2 = StructuralResource2.getInstance((ReadGraph)graph);
        SysdynResource SR = SysdynResource.getInstance((ReadGraph)graph);
        for (Resource module : moduleInstanceFinder.find((ReadGraph)graph, indexRoot)) {
            for (Statement stm : graph.getStatements(module, SR2.IsConnectedTo)) {
                Resource connection = stm.getObject();
                Resource ref = graph.getPossibleObject(connection, SR.Dependency_refersTo);
                if (ref == null || !ref.equals(reference)) continue;
                graph.deny(connection, SR.Dependency_refersTo);
            }
        }
    }
}

